/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the association.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssociationOverview implements SdkPojo, Serializable,
        ToCopyableBuilder<AssociationOverview.Builder, AssociationOverview> {
    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(AssociationOverview::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> DETAILED_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DetailedStatus").getter(getter(AssociationOverview::detailedStatus))
            .setter(setter(Builder::detailedStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DetailedStatus").build()).build();

    private static final SdkField<Map<String, Integer>> ASSOCIATION_STATUS_AGGREGATED_COUNT_FIELD = SdkField
            .<Map<String, Integer>> builder(MarshallingType.MAP)
            .memberName("AssociationStatusAggregatedCount")
            .getter(getter(AssociationOverview::associationStatusAggregatedCount))
            .setter(setter(Builder::associationStatusAggregatedCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociationStatusAggregatedCount")
                    .build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<Integer> builder(MarshallingType.INTEGER)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD,
            DETAILED_STATUS_FIELD, ASSOCIATION_STATUS_AGGREGATED_COUNT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String status;

    private final String detailedStatus;

    private final Map<String, Integer> associationStatusAggregatedCount;

    private AssociationOverview(BuilderImpl builder) {
        this.status = builder.status;
        this.detailedStatus = builder.detailedStatus;
        this.associationStatusAggregatedCount = builder.associationStatusAggregatedCount;
    }

    /**
     * <p>
     * The status of the association. Status can be: Pending, Success, or Failed.
     * </p>
     * 
     * @return The status of the association. Status can be: Pending, Success, or Failed.
     */
    public final String status() {
        return status;
    }

    /**
     * <p>
     * A detailed status of the association.
     * </p>
     * 
     * @return A detailed status of the association.
     */
    public final String detailedStatus() {
        return detailedStatus;
    }

    /**
     * For responses, this returns true if the service returned a value for the AssociationStatusAggregatedCount
     * property. This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()}
     * method on the property). This is useful because the SDK will never return a null collection or map, but you may
     * need to differentiate between the service returning nothing (or null) and the service returning an empty
     * collection or map. For requests, this returns true if a value for the property was specified in the request
     * builder, and false if a value was not specified.
     */
    public final boolean hasAssociationStatusAggregatedCount() {
        return associationStatusAggregatedCount != null && !(associationStatusAggregatedCount instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Returns the number of targets for the association status. For example, if you created an association with two
     * managed nodes, and one of them was successful, this would return the count of managed nodes by status.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAssociationStatusAggregatedCount}
     * method.
     * </p>
     * 
     * @return Returns the number of targets for the association status. For example, if you created an association with
     *         two managed nodes, and one of them was successful, this would return the count of managed nodes by
     *         status.
     */
    public final Map<String, Integer> associationStatusAggregatedCount() {
        return associationStatusAggregatedCount;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(detailedStatus());
        hashCode = 31 * hashCode
                + Objects.hashCode(hasAssociationStatusAggregatedCount() ? associationStatusAggregatedCount() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociationOverview)) {
            return false;
        }
        AssociationOverview other = (AssociationOverview) obj;
        return Objects.equals(status(), other.status()) && Objects.equals(detailedStatus(), other.detailedStatus())
                && hasAssociationStatusAggregatedCount() == other.hasAssociationStatusAggregatedCount()
                && Objects.equals(associationStatusAggregatedCount(), other.associationStatusAggregatedCount());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("AssociationOverview")
                .add("Status", status())
                .add("DetailedStatus", detailedStatus())
                .add("AssociationStatusAggregatedCount",
                        hasAssociationStatusAggregatedCount() ? associationStatusAggregatedCount() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        case "DetailedStatus":
            return Optional.ofNullable(clazz.cast(detailedStatus()));
        case "AssociationStatusAggregatedCount":
            return Optional.ofNullable(clazz.cast(associationStatusAggregatedCount()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AssociationOverview, T> g) {
        return obj -> g.apply((AssociationOverview) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AssociationOverview> {
        /**
         * <p>
         * The status of the association. Status can be: Pending, Success, or Failed.
         * </p>
         * 
         * @param status
         *        The status of the association. Status can be: Pending, Success, or Failed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * A detailed status of the association.
         * </p>
         * 
         * @param detailedStatus
         *        A detailed status of the association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder detailedStatus(String detailedStatus);

        /**
         * <p>
         * Returns the number of targets for the association status. For example, if you created an association with two
         * managed nodes, and one of them was successful, this would return the count of managed nodes by status.
         * </p>
         * 
         * @param associationStatusAggregatedCount
         *        Returns the number of targets for the association status. For example, if you created an association
         *        with two managed nodes, and one of them was successful, this would return the count of managed nodes
         *        by status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associationStatusAggregatedCount(Map<String, Integer> associationStatusAggregatedCount);
    }

    static final class BuilderImpl implements Builder {
        private String status;

        private String detailedStatus;

        private Map<String, Integer> associationStatusAggregatedCount = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AssociationOverview model) {
            status(model.status);
            detailedStatus(model.detailedStatus);
            associationStatusAggregatedCount(model.associationStatusAggregatedCount);
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        @Transient
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final String getDetailedStatus() {
            return detailedStatus;
        }

        public final void setDetailedStatus(String detailedStatus) {
            this.detailedStatus = detailedStatus;
        }

        @Override
        @Transient
        public final Builder detailedStatus(String detailedStatus) {
            this.detailedStatus = detailedStatus;
            return this;
        }

        public final Map<String, Integer> getAssociationStatusAggregatedCount() {
            if (associationStatusAggregatedCount instanceof SdkAutoConstructMap) {
                return null;
            }
            return associationStatusAggregatedCount;
        }

        public final void setAssociationStatusAggregatedCount(Map<String, Integer> associationStatusAggregatedCount) {
            this.associationStatusAggregatedCount = AssociationStatusAggregatedCountCopier.copy(associationStatusAggregatedCount);
        }

        @Override
        @Transient
        public final Builder associationStatusAggregatedCount(Map<String, Integer> associationStatusAggregatedCount) {
            this.associationStatusAggregatedCount = AssociationStatusAggregatedCountCopier.copy(associationStatusAggregatedCount);
            return this;
        }

        @Override
        public AssociationOverview build() {
            return new AssociationOverview(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
