/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A URL for the Amazon Web Services Systems Manager (Systems Manager) bucket where you want to store the results of
 * this request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class S3OutputUrl implements SdkPojo, Serializable, ToCopyableBuilder<S3OutputUrl.Builder, S3OutputUrl> {
    private static final SdkField<String> OUTPUT_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OutputUrl").getter(getter(S3OutputUrl::outputUrl)).setter(setter(Builder::outputUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputUrl").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OUTPUT_URL_FIELD));

    private static final long serialVersionUID = 1L;

    private final String outputUrl;

    private S3OutputUrl(BuilderImpl builder) {
        this.outputUrl = builder.outputUrl;
    }

    /**
     * <p>
     * A URL for an S3 bucket where you want to store the results of this request.
     * </p>
     * 
     * @return A URL for an S3 bucket where you want to store the results of this request.
     */
    public final String outputUrl() {
        return outputUrl;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(outputUrl());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3OutputUrl)) {
            return false;
        }
        S3OutputUrl other = (S3OutputUrl) obj;
        return Objects.equals(outputUrl(), other.outputUrl());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("S3OutputUrl").add("OutputUrl", outputUrl()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OutputUrl":
            return Optional.ofNullable(clazz.cast(outputUrl()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<S3OutputUrl, T> g) {
        return obj -> g.apply((S3OutputUrl) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, S3OutputUrl> {
        /**
         * <p>
         * A URL for an S3 bucket where you want to store the results of this request.
         * </p>
         * 
         * @param outputUrl
         *        A URL for an S3 bucket where you want to store the results of this request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputUrl(String outputUrl);
    }

    static final class BuilderImpl implements Builder {
        private String outputUrl;

        private BuilderImpl() {
        }

        private BuilderImpl(S3OutputUrl model) {
            outputUrl(model.outputUrl);
        }

        public final String getOutputUrl() {
            return outputUrl;
        }

        public final void setOutputUrl(String outputUrl) {
            this.outputUrl = outputUrl;
        }

        @Override
        @Transient
        public final Builder outputUrl(String outputUrl) {
            this.outputUrl = outputUrl;
            return this;
        }

        @Override
        public S3OutputUrl build() {
            return new S3OutputUrl(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
