/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssmcontacts.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum AcceptType {
    DELIVERED("DELIVERED"),
    READ("READ"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private AcceptType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AcceptType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(AcceptType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AcceptType> knownValues() {
        return Stream.of(AcceptType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

