/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssmcontacts.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ssmcontacts.model.ReceiptType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Receipt
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Receipt> {
    private static final SdkField<String> CONTACT_CHANNEL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ContactChannelArn").getter(Receipt.getter(Receipt::contactChannelArn)).setter(Receipt.setter(Builder::contactChannelArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContactChannelArn").build()}).build();
    private static final SdkField<String> RECEIPT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReceiptType").getter(Receipt.getter(Receipt::receiptTypeAsString)).setter(Receipt.setter(Builder::receiptType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReceiptType").build()}).build();
    private static final SdkField<String> RECEIPT_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReceiptInfo").getter(Receipt.getter(Receipt::receiptInfo)).setter(Receipt.setter(Builder::receiptInfo)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReceiptInfo").build()}).build();
    private static final SdkField<Instant> RECEIPT_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ReceiptTime").getter(Receipt.getter(Receipt::receiptTime)).setter(Receipt.setter(Builder::receiptTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReceiptTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTACT_CHANNEL_ARN_FIELD, RECEIPT_TYPE_FIELD, RECEIPT_INFO_FIELD, RECEIPT_TIME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String contactChannelArn;
    private final String receiptType;
    private final String receiptInfo;
    private final Instant receiptTime;

    private Receipt(BuilderImpl builder) {
        this.contactChannelArn = builder.contactChannelArn;
        this.receiptType = builder.receiptType;
        this.receiptInfo = builder.receiptInfo;
        this.receiptTime = builder.receiptTime;
    }

    public final String contactChannelArn() {
        return this.contactChannelArn;
    }

    public final ReceiptType receiptType() {
        return ReceiptType.fromValue(this.receiptType);
    }

    public final String receiptTypeAsString() {
        return this.receiptType;
    }

    public final String receiptInfo() {
        return this.receiptInfo;
    }

    public final Instant receiptTime() {
        return this.receiptTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.contactChannelArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.receiptTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.receiptInfo());
        hashCode = 31 * hashCode + Objects.hashCode(this.receiptTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Receipt)) {
            return false;
        }
        Receipt other = (Receipt)obj;
        return Objects.equals(this.contactChannelArn(), other.contactChannelArn()) && Objects.equals(this.receiptTypeAsString(), other.receiptTypeAsString()) && Objects.equals(this.receiptInfo(), other.receiptInfo()) && Objects.equals(this.receiptTime(), other.receiptTime());
    }

    public final String toString() {
        return ToString.builder((String)"Receipt").add("ContactChannelArn", (Object)this.contactChannelArn()).add("ReceiptType", (Object)this.receiptTypeAsString()).add("ReceiptInfo", (Object)this.receiptInfo()).add("ReceiptTime", (Object)this.receiptTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ContactChannelArn": {
                return Optional.ofNullable(clazz.cast(this.contactChannelArn()));
            }
            case "ReceiptType": {
                return Optional.ofNullable(clazz.cast(this.receiptTypeAsString()));
            }
            case "ReceiptInfo": {
                return Optional.ofNullable(clazz.cast(this.receiptInfo()));
            }
            case "ReceiptTime": {
                return Optional.ofNullable(clazz.cast(this.receiptTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Receipt, T> g) {
        return obj -> g.apply((Receipt)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String contactChannelArn;
        private String receiptType;
        private String receiptInfo;
        private Instant receiptTime;

        private BuilderImpl() {
        }

        private BuilderImpl(Receipt model) {
            this.contactChannelArn(model.contactChannelArn);
            this.receiptType(model.receiptType);
            this.receiptInfo(model.receiptInfo);
            this.receiptTime(model.receiptTime);
        }

        public final String getContactChannelArn() {
            return this.contactChannelArn;
        }

        @Override
        public final Builder contactChannelArn(String contactChannelArn) {
            this.contactChannelArn = contactChannelArn;
            return this;
        }

        public final void setContactChannelArn(String contactChannelArn) {
            this.contactChannelArn = contactChannelArn;
        }

        public final String getReceiptType() {
            return this.receiptType;
        }

        @Override
        public final Builder receiptType(String receiptType) {
            this.receiptType = receiptType;
            return this;
        }

        @Override
        public final Builder receiptType(ReceiptType receiptType) {
            this.receiptType(receiptType == null ? null : receiptType.toString());
            return this;
        }

        public final void setReceiptType(String receiptType) {
            this.receiptType = receiptType;
        }

        public final String getReceiptInfo() {
            return this.receiptInfo;
        }

        @Override
        public final Builder receiptInfo(String receiptInfo) {
            this.receiptInfo = receiptInfo;
            return this;
        }

        public final void setReceiptInfo(String receiptInfo) {
            this.receiptInfo = receiptInfo;
        }

        public final Instant getReceiptTime() {
            return this.receiptTime;
        }

        @Override
        public final Builder receiptTime(Instant receiptTime) {
            this.receiptTime = receiptTime;
            return this;
        }

        public final void setReceiptTime(Instant receiptTime) {
            this.receiptTime = receiptTime;
        }

        public Receipt build() {
            return new Receipt(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Receipt> {
        public Builder contactChannelArn(String var1);

        public Builder receiptType(String var1);

        public Builder receiptType(ReceiptType var1);

        public Builder receiptInfo(String var1);

        public Builder receiptTime(Instant var1);
    }
}

