/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssmcontacts.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ssmcontacts.model.SsmContactsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartEngagementRequest
extends SsmContactsRequest
implements ToCopyableBuilder<Builder, StartEngagementRequest> {
    private static final SdkField<String> CONTACT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ContactId").getter(StartEngagementRequest.getter(StartEngagementRequest::contactId)).setter(StartEngagementRequest.setter(Builder::contactId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContactId").build()}).build();
    private static final SdkField<String> SENDER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Sender").getter(StartEngagementRequest.getter(StartEngagementRequest::sender)).setter(StartEngagementRequest.setter(Builder::sender)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Sender").build()}).build();
    private static final SdkField<String> SUBJECT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Subject").getter(StartEngagementRequest.getter(StartEngagementRequest::subject)).setter(StartEngagementRequest.setter(Builder::subject)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Subject").build()}).build();
    private static final SdkField<String> CONTENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Content").getter(StartEngagementRequest.getter(StartEngagementRequest::content)).setter(StartEngagementRequest.setter(Builder::content)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Content").build()}).build();
    private static final SdkField<String> PUBLIC_SUBJECT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PublicSubject").getter(StartEngagementRequest.getter(StartEngagementRequest::publicSubject)).setter(StartEngagementRequest.setter(Builder::publicSubject)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PublicSubject").build()}).build();
    private static final SdkField<String> PUBLIC_CONTENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PublicContent").getter(StartEngagementRequest.getter(StartEngagementRequest::publicContent)).setter(StartEngagementRequest.setter(Builder::publicContent)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PublicContent").build()}).build();
    private static final SdkField<String> INCIDENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IncidentId").getter(StartEngagementRequest.getter(StartEngagementRequest::incidentId)).setter(StartEngagementRequest.setter(Builder::incidentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncidentId").build()}).build();
    private static final SdkField<String> IDEMPOTENCY_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IdempotencyToken").getter(StartEngagementRequest.getter(StartEngagementRequest::idempotencyToken)).setter(StartEngagementRequest.setter(Builder::idempotencyToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdempotencyToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTACT_ID_FIELD, SENDER_FIELD, SUBJECT_FIELD, CONTENT_FIELD, PUBLIC_SUBJECT_FIELD, PUBLIC_CONTENT_FIELD, INCIDENT_ID_FIELD, IDEMPOTENCY_TOKEN_FIELD));
    private final String contactId;
    private final String sender;
    private final String subject;
    private final String content;
    private final String publicSubject;
    private final String publicContent;
    private final String incidentId;
    private final String idempotencyToken;

    private StartEngagementRequest(BuilderImpl builder) {
        super(builder);
        this.contactId = builder.contactId;
        this.sender = builder.sender;
        this.subject = builder.subject;
        this.content = builder.content;
        this.publicSubject = builder.publicSubject;
        this.publicContent = builder.publicContent;
        this.incidentId = builder.incidentId;
        this.idempotencyToken = builder.idempotencyToken;
    }

    public final String contactId() {
        return this.contactId;
    }

    public final String sender() {
        return this.sender;
    }

    public final String subject() {
        return this.subject;
    }

    public final String content() {
        return this.content;
    }

    public final String publicSubject() {
        return this.publicSubject;
    }

    public final String publicContent() {
        return this.publicContent;
    }

    public final String incidentId() {
        return this.incidentId;
    }

    public final String idempotencyToken() {
        return this.idempotencyToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.contactId());
        hashCode = 31 * hashCode + Objects.hashCode(this.sender());
        hashCode = 31 * hashCode + Objects.hashCode(this.subject());
        hashCode = 31 * hashCode + Objects.hashCode(this.content());
        hashCode = 31 * hashCode + Objects.hashCode(this.publicSubject());
        hashCode = 31 * hashCode + Objects.hashCode(this.publicContent());
        hashCode = 31 * hashCode + Objects.hashCode(this.incidentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.idempotencyToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartEngagementRequest)) {
            return false;
        }
        StartEngagementRequest other = (StartEngagementRequest)((Object)obj);
        return Objects.equals(this.contactId(), other.contactId()) && Objects.equals(this.sender(), other.sender()) && Objects.equals(this.subject(), other.subject()) && Objects.equals(this.content(), other.content()) && Objects.equals(this.publicSubject(), other.publicSubject()) && Objects.equals(this.publicContent(), other.publicContent()) && Objects.equals(this.incidentId(), other.incidentId()) && Objects.equals(this.idempotencyToken(), other.idempotencyToken());
    }

    public final String toString() {
        return ToString.builder((String)"StartEngagementRequest").add("ContactId", (Object)this.contactId()).add("Sender", (Object)this.sender()).add("Subject", (Object)this.subject()).add("Content", (Object)this.content()).add("PublicSubject", (Object)this.publicSubject()).add("PublicContent", (Object)this.publicContent()).add("IncidentId", (Object)this.incidentId()).add("IdempotencyToken", (Object)this.idempotencyToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ContactId": {
                return Optional.ofNullable(clazz.cast(this.contactId()));
            }
            case "Sender": {
                return Optional.ofNullable(clazz.cast(this.sender()));
            }
            case "Subject": {
                return Optional.ofNullable(clazz.cast(this.subject()));
            }
            case "Content": {
                return Optional.ofNullable(clazz.cast(this.content()));
            }
            case "PublicSubject": {
                return Optional.ofNullable(clazz.cast(this.publicSubject()));
            }
            case "PublicContent": {
                return Optional.ofNullable(clazz.cast(this.publicContent()));
            }
            case "IncidentId": {
                return Optional.ofNullable(clazz.cast(this.incidentId()));
            }
            case "IdempotencyToken": {
                return Optional.ofNullable(clazz.cast(this.idempotencyToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartEngagementRequest, T> g) {
        return obj -> g.apply((StartEngagementRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SsmContactsRequest.BuilderImpl
    implements Builder {
        private String contactId;
        private String sender;
        private String subject;
        private String content;
        private String publicSubject;
        private String publicContent;
        private String incidentId;
        private String idempotencyToken;

        private BuilderImpl() {
        }

        private BuilderImpl(StartEngagementRequest model) {
            super(model);
            this.contactId(model.contactId);
            this.sender(model.sender);
            this.subject(model.subject);
            this.content(model.content);
            this.publicSubject(model.publicSubject);
            this.publicContent(model.publicContent);
            this.incidentId(model.incidentId);
            this.idempotencyToken(model.idempotencyToken);
        }

        public final String getContactId() {
            return this.contactId;
        }

        @Override
        public final Builder contactId(String contactId) {
            this.contactId = contactId;
            return this;
        }

        public final void setContactId(String contactId) {
            this.contactId = contactId;
        }

        public final String getSender() {
            return this.sender;
        }

        @Override
        public final Builder sender(String sender) {
            this.sender = sender;
            return this;
        }

        public final void setSender(String sender) {
            this.sender = sender;
        }

        public final String getSubject() {
            return this.subject;
        }

        @Override
        public final Builder subject(String subject) {
            this.subject = subject;
            return this;
        }

        public final void setSubject(String subject) {
            this.subject = subject;
        }

        public final String getContent() {
            return this.content;
        }

        @Override
        public final Builder content(String content) {
            this.content = content;
            return this;
        }

        public final void setContent(String content) {
            this.content = content;
        }

        public final String getPublicSubject() {
            return this.publicSubject;
        }

        @Override
        public final Builder publicSubject(String publicSubject) {
            this.publicSubject = publicSubject;
            return this;
        }

        public final void setPublicSubject(String publicSubject) {
            this.publicSubject = publicSubject;
        }

        public final String getPublicContent() {
            return this.publicContent;
        }

        @Override
        public final Builder publicContent(String publicContent) {
            this.publicContent = publicContent;
            return this;
        }

        public final void setPublicContent(String publicContent) {
            this.publicContent = publicContent;
        }

        public final String getIncidentId() {
            return this.incidentId;
        }

        @Override
        public final Builder incidentId(String incidentId) {
            this.incidentId = incidentId;
            return this;
        }

        public final void setIncidentId(String incidentId) {
            this.incidentId = incidentId;
        }

        public final String getIdempotencyToken() {
            return this.idempotencyToken;
        }

        @Override
        public final Builder idempotencyToken(String idempotencyToken) {
            this.idempotencyToken = idempotencyToken;
            return this;
        }

        public final void setIdempotencyToken(String idempotencyToken) {
            this.idempotencyToken = idempotencyToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartEngagementRequest build() {
            return new StartEngagementRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SsmContactsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartEngagementRequest> {
        public Builder contactId(String var1);

        public Builder sender(String var1);

        public Builder subject(String var1);

        public Builder content(String var1);

        public Builder publicSubject(String var1);

        public Builder publicContent(String var1);

        public Builder incidentId(String var1);

        public Builder idempotencyToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

