/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssmincidents.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Resources that responders use to triage and mitigate the incident.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RelatedItem implements SdkPojo, Serializable, ToCopyableBuilder<RelatedItem.Builder, RelatedItem> {
    private static final SdkField<String> GENERATED_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("generatedId").getter(getter(RelatedItem::generatedId)).setter(setter(Builder::generatedId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("generatedId").build()).build();

    private static final SdkField<ItemIdentifier> IDENTIFIER_FIELD = SdkField.<ItemIdentifier> builder(MarshallingType.SDK_POJO)
            .memberName("identifier").getter(getter(RelatedItem::identifier)).setter(setter(Builder::identifier))
            .constructor(ItemIdentifier::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("identifier").build()).build();

    private static final SdkField<String> TITLE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("title")
            .getter(getter(RelatedItem::title)).setter(setter(Builder::title))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("title").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GENERATED_ID_FIELD,
            IDENTIFIER_FIELD, TITLE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String generatedId;

    private final ItemIdentifier identifier;

    private final String title;

    private RelatedItem(BuilderImpl builder) {
        this.generatedId = builder.generatedId;
        this.identifier = builder.identifier;
        this.title = builder.title;
    }

    /**
     * <p>
     * A unique ID for a <code>RelatedItem</code>.
     * </p>
     * <important>
     * <p>
     * Don't specify this parameter when you add a <code>RelatedItem</code> by using the <a>UpdateRelatedItems</a> API
     * action.
     * </p>
     * </important>
     * 
     * @return A unique ID for a <code>RelatedItem</code>.</p> <important>
     *         <p>
     *         Don't specify this parameter when you add a <code>RelatedItem</code> by using the
     *         <a>UpdateRelatedItems</a> API action.
     *         </p>
     */
    public final String generatedId() {
        return generatedId;
    }

    /**
     * <p>
     * Details about the related item.
     * </p>
     * 
     * @return Details about the related item.
     */
    public final ItemIdentifier identifier() {
        return identifier;
    }

    /**
     * <p>
     * The title of the related item.
     * </p>
     * 
     * @return The title of the related item.
     */
    public final String title() {
        return title;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(generatedId());
        hashCode = 31 * hashCode + Objects.hashCode(identifier());
        hashCode = 31 * hashCode + Objects.hashCode(title());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RelatedItem)) {
            return false;
        }
        RelatedItem other = (RelatedItem) obj;
        return Objects.equals(generatedId(), other.generatedId()) && Objects.equals(identifier(), other.identifier())
                && Objects.equals(title(), other.title());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RelatedItem").add("GeneratedId", generatedId()).add("Identifier", identifier())
                .add("Title", title()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "generatedId":
            return Optional.ofNullable(clazz.cast(generatedId()));
        case "identifier":
            return Optional.ofNullable(clazz.cast(identifier()));
        case "title":
            return Optional.ofNullable(clazz.cast(title()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RelatedItem, T> g) {
        return obj -> g.apply((RelatedItem) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RelatedItem> {
        /**
         * <p>
         * A unique ID for a <code>RelatedItem</code>.
         * </p>
         * <important>
         * <p>
         * Don't specify this parameter when you add a <code>RelatedItem</code> by using the <a>UpdateRelatedItems</a>
         * API action.
         * </p>
         * </important>
         * 
         * @param generatedId
         *        A unique ID for a <code>RelatedItem</code>.</p> <important>
         *        <p>
         *        Don't specify this parameter when you add a <code>RelatedItem</code> by using the
         *        <a>UpdateRelatedItems</a> API action.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder generatedId(String generatedId);

        /**
         * <p>
         * Details about the related item.
         * </p>
         * 
         * @param identifier
         *        Details about the related item.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identifier(ItemIdentifier identifier);

        /**
         * <p>
         * Details about the related item.
         * </p>
         * This is a convenience method that creates an instance of the {@link ItemIdentifier.Builder} avoiding the need
         * to create one manually via {@link ItemIdentifier#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ItemIdentifier.Builder#build()} is called immediately and its
         * result is passed to {@link #identifier(ItemIdentifier)}.
         * 
         * @param identifier
         *        a consumer that will call methods on {@link ItemIdentifier.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #identifier(ItemIdentifier)
         */
        default Builder identifier(Consumer<ItemIdentifier.Builder> identifier) {
            return identifier(ItemIdentifier.builder().applyMutation(identifier).build());
        }

        /**
         * <p>
         * The title of the related item.
         * </p>
         * 
         * @param title
         *        The title of the related item.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder title(String title);
    }

    static final class BuilderImpl implements Builder {
        private String generatedId;

        private ItemIdentifier identifier;

        private String title;

        private BuilderImpl() {
        }

        private BuilderImpl(RelatedItem model) {
            generatedId(model.generatedId);
            identifier(model.identifier);
            title(model.title);
        }

        public final String getGeneratedId() {
            return generatedId;
        }

        public final void setGeneratedId(String generatedId) {
            this.generatedId = generatedId;
        }

        @Override
        public final Builder generatedId(String generatedId) {
            this.generatedId = generatedId;
            return this;
        }

        public final ItemIdentifier.Builder getIdentifier() {
            return identifier != null ? identifier.toBuilder() : null;
        }

        public final void setIdentifier(ItemIdentifier.BuilderImpl identifier) {
            this.identifier = identifier != null ? identifier.build() : null;
        }

        @Override
        public final Builder identifier(ItemIdentifier identifier) {
            this.identifier = identifier;
            return this;
        }

        public final String getTitle() {
            return title;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        @Override
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        @Override
        public RelatedItem build() {
            return new RelatedItem(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
