/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sso.auth;

import java.nio.file.Paths;
import java.util.Optional;
import java.util.function.Supplier;
import software.amazon.awssdk.annotations.SdkProtectedApi;
import software.amazon.awssdk.annotations.SdkTestInternalApi;
import software.amazon.awssdk.auth.credentials.AnonymousCredentialsProvider;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.ProfileCredentialsProviderFactory;
import software.amazon.awssdk.auth.credentials.ProfileProviderCredentialsContext;
import software.amazon.awssdk.auth.token.credentials.ProfileTokenProvider;
import software.amazon.awssdk.auth.token.credentials.SdkToken;
import software.amazon.awssdk.auth.token.credentials.SdkTokenProvider;
import software.amazon.awssdk.auth.token.internal.LazyTokenProvider;
import software.amazon.awssdk.profiles.Profile;
import software.amazon.awssdk.profiles.ProfileFile;
import software.amazon.awssdk.profiles.internal.ProfileSection;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.sso.SsoClient;
import software.amazon.awssdk.services.sso.SsoClientBuilder;
import software.amazon.awssdk.services.sso.auth.SsoCredentialsProvider;
import software.amazon.awssdk.services.sso.internal.SsoAccessTokenProvider;
import software.amazon.awssdk.services.sso.internal.SsoTokenFileUtils;
import software.amazon.awssdk.services.sso.model.GetRoleCredentialsRequest;
import software.amazon.awssdk.utils.IoUtils;
import software.amazon.awssdk.utils.SdkAutoCloseable;
import software.amazon.awssdk.utils.UserHomeDirectoryUtils;
import software.amazon.awssdk.utils.Validate;

@SdkProtectedApi
public class SsoProfileCredentialsProviderFactory
implements ProfileCredentialsProviderFactory {
    private static final String TOKEN_DIRECTORY = Paths.get(UserHomeDirectoryUtils.userHomeDirectory(), ".aws", "sso", "cache").toString();
    private static final String MISSING_PROPERTY_ERROR_FORMAT = "'%s' must be set to use role-based credential loading in the '%s' profile.";

    public AwsCredentialsProvider create(ProfileProviderCredentialsContext credentialsContext) {
        return new SsoProfileCredentialsProvider(credentialsContext.profile(), credentialsContext.profileFile(), SsoProfileCredentialsProviderFactory.sdkTokenProvider(credentialsContext.profile(), credentialsContext.profileFile()));
    }

    @SdkTestInternalApi
    public AwsCredentialsProvider create(Profile profile, ProfileFile profileFile, SdkTokenProvider tokenProvider) {
        return new SsoProfileCredentialsProvider(profile, profileFile, tokenProvider);
    }

    private static Profile ssoSessionInProfile(String sessionName, ProfileFile profileFile) {
        Profile ssoProfile = (Profile)profileFile.getSection(ProfileSection.SSO_SESSION.getSectionTitle(), sessionName).orElseThrow(() -> new IllegalArgumentException("Sso-session section not found with sso-session title " + sessionName + "."));
        return ssoProfile;
    }

    private static SdkTokenProvider sdkTokenProvider(Profile profile, ProfileFile profileFile) {
        Optional ssoSession = profile.property(ProfileSection.SSO_SESSION.getPropertyKeyName());
        if (ssoSession.isPresent()) {
            Profile ssoSessionProfileFile = SsoProfileCredentialsProviderFactory.ssoSessionInProfile((String)ssoSession.get(), profileFile);
            SsoProfileCredentialsProviderFactory.validateCommonProfileProperties(profile, ssoSessionProfileFile, "sso_region");
            SsoProfileCredentialsProviderFactory.validateCommonProfileProperties(profile, ssoSessionProfileFile, "sso_start_url");
            return LazyTokenProvider.create(() -> ProfileTokenProvider.builder().profileFile(() -> profileFile).profileName(profile.name()).build());
        }
        return new SsoAccessTokenProvider(SsoTokenFileUtils.generateCachedTokenPath((String)profile.properties().get("sso_start_url"), TOKEN_DIRECTORY));
    }

    private static void validateCommonProfileProperties(Profile profile, Profile ssoSessionProfileFile, String propertyName) {
        profile.property(propertyName).ifPresent(property -> Validate.isTrue((boolean)property.equalsIgnoreCase((String)ssoSessionProfileFile.property(propertyName).get()), (String)("Profile " + profile.name() + " and Sso-session " + ssoSessionProfileFile.name() + " has different " + propertyName + "."), (Object[])new Object[0]));
    }

    private static final class SsoProfileCredentialsProvider
    implements AwsCredentialsProvider,
    SdkAutoCloseable {
        private final SsoClient ssoClient;
        private final SsoCredentialsProvider credentialsProvider;

        private SsoProfileCredentialsProvider(Profile profile, ProfileFile profileFile, SdkTokenProvider tokenProvider) {
            String ssoAccountId = (String)profile.properties().get("sso_account_id");
            String ssoRoleName = (String)profile.properties().get("sso_role_name");
            String ssoRegion = SsoProfileCredentialsProvider.regionFromProfileOrSession(profile, profileFile);
            this.ssoClient = (SsoClient)((SsoClientBuilder)((SsoClientBuilder)SsoClient.builder().credentialsProvider((AwsCredentialsProvider)AnonymousCredentialsProvider.create())).region(Region.of((String)ssoRegion))).build();
            GetRoleCredentialsRequest request = (GetRoleCredentialsRequest)((Object)GetRoleCredentialsRequest.builder().accountId(ssoAccountId).roleName(ssoRoleName).build());
            SdkToken sdkToken = tokenProvider.resolveToken();
            Validate.paramNotNull((Object)sdkToken, (String)"Token provided by the TokenProvider is null");
            Supplier<GetRoleCredentialsRequest> supplier = () -> (GetRoleCredentialsRequest)((Object)((Object)request.toBuilder().accessToken(sdkToken.token()).build()));
            this.credentialsProvider = SsoCredentialsProvider.builder().ssoClient(this.ssoClient).refreshRequest(supplier).build();
        }

        public AwsCredentials resolveCredentials() {
            return this.credentialsProvider.resolveCredentials();
        }

        public void close() {
            IoUtils.closeQuietly((AutoCloseable)((Object)this.credentialsProvider), null);
            IoUtils.closeQuietly((AutoCloseable)((Object)this.ssoClient), null);
        }

        private static String regionFromProfileOrSession(Profile profile, ProfileFile profileFile) {
            Optional ssoSession = profile.property(ProfileSection.SSO_SESSION.getPropertyKeyName());
            String profileRegion = (String)profile.properties().get("sso_region");
            return ssoSession.isPresent() ? SsoProfileCredentialsProvider.propertyFromSsoSession((String)ssoSession.get(), profileFile, "sso_region") : profileRegion;
        }

        private static String propertyFromSsoSession(String sessionName, ProfileFile profileFile, String propertyName) {
            Profile ssoProfile = SsoProfileCredentialsProviderFactory.ssoSessionInProfile(sessionName, profileFile);
            return SsoProfileCredentialsProvider.requireProperty(ssoProfile, propertyName);
        }

        private static String requireProperty(Profile profile, String requiredProperty) {
            return (String)profile.property(requiredProperty).orElseThrow(() -> new IllegalArgumentException(String.format(SsoProfileCredentialsProviderFactory.MISSING_PROPERTY_ERROR_FORMAT, requiredProperty, profile.name())));
        }
    }
}

