/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sso.auth;

import java.time.Duration;
import java.time.Instant;
import java.util.Optional;
import java.util.function.Supplier;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.AwsSessionCredentials;
import software.amazon.awssdk.services.sso.SsoClient;
import software.amazon.awssdk.services.sso.internal.SessionCredentialsHolder;
import software.amazon.awssdk.services.sso.model.GetRoleCredentialsRequest;
import software.amazon.awssdk.services.sso.model.RoleCredentials;
import software.amazon.awssdk.utils.SdkAutoCloseable;
import software.amazon.awssdk.utils.Validate;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;
import software.amazon.awssdk.utils.cache.CachedSupplier;
import software.amazon.awssdk.utils.cache.NonBlocking;
import software.amazon.awssdk.utils.cache.RefreshResult;

@SdkPublicApi
public final class SsoCredentialsProvider
implements AwsCredentialsProvider,
SdkAutoCloseable,
ToCopyableBuilder<Builder, SsoCredentialsProvider> {
    private static final String PROVIDER_NAME = "SsoCredentialsProvider";
    private static final Duration DEFAULT_STALE_TIME = Duration.ofMinutes(1L);
    private static final Duration DEFAULT_PREFETCH_TIME = Duration.ofMinutes(5L);
    private static final String ASYNC_THREAD_NAME = "sdk-sso-credentials-provider";
    private final Supplier<GetRoleCredentialsRequest> getRoleCredentialsRequestSupplier;
    private final SsoClient ssoClient;
    private final Duration staleTime;
    private final Duration prefetchTime;
    private final CachedSupplier<SessionCredentialsHolder> credentialCache;
    private final Boolean asyncCredentialUpdateEnabled;

    private SsoCredentialsProvider(BuilderImpl builder) {
        this.ssoClient = (SsoClient)Validate.notNull((Object)builder.ssoClient, (String)"SSO client must not be null.", (Object[])new Object[0]);
        this.getRoleCredentialsRequestSupplier = builder.getRoleCredentialsRequestSupplier;
        this.staleTime = Optional.ofNullable(builder.staleTime).orElse(DEFAULT_STALE_TIME);
        this.prefetchTime = Optional.ofNullable(builder.prefetchTime).orElse(DEFAULT_PREFETCH_TIME);
        this.asyncCredentialUpdateEnabled = builder.asyncCredentialUpdateEnabled;
        CachedSupplier.Builder cacheBuilder = CachedSupplier.builder(this::updateSsoCredentials).cachedValueName(this.toString());
        if (builder.asyncCredentialUpdateEnabled.booleanValue()) {
            cacheBuilder.prefetchStrategy((CachedSupplier.PrefetchStrategy)new NonBlocking(ASYNC_THREAD_NAME));
        }
        this.credentialCache = cacheBuilder.build();
    }

    private RefreshResult<SessionCredentialsHolder> updateSsoCredentials() {
        SessionCredentialsHolder credentials = this.getUpdatedCredentials(this.ssoClient);
        Instant acutalTokenExpiration = credentials.sessionCredentialsExpiration();
        return RefreshResult.builder((Object)credentials).staleTime(acutalTokenExpiration.minus(this.staleTime)).prefetchTime(acutalTokenExpiration.minus(this.prefetchTime)).build();
    }

    private SessionCredentialsHolder getUpdatedCredentials(SsoClient ssoClient) {
        GetRoleCredentialsRequest request = this.getRoleCredentialsRequestSupplier.get();
        Validate.notNull((Object)((Object)request), (String)"GetRoleCredentialsRequest can't be null.", (Object[])new Object[0]);
        RoleCredentials roleCredentials = ssoClient.getRoleCredentials(request).roleCredentials();
        AwsSessionCredentials sessionCredentials = AwsSessionCredentials.builder().accessKeyId(roleCredentials.accessKeyId()).secretAccessKey(roleCredentials.secretAccessKey()).sessionToken(roleCredentials.sessionToken()).accountId(request.accountId()).providerName(PROVIDER_NAME).build();
        return new SessionCredentialsHolder(sessionCredentials, Instant.ofEpochMilli(roleCredentials.expiration()));
    }

    public Duration staleTime() {
        return this.staleTime;
    }

    public Duration prefetchTime() {
        return this.prefetchTime;
    }

    public static BuilderImpl builder() {
        return new BuilderImpl();
    }

    public AwsCredentials resolveCredentials() {
        return ((SessionCredentialsHolder)this.credentialCache.get()).sessionCredentials();
    }

    public void close() {
        this.credentialCache.close();
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    protected static final class BuilderImpl
    implements Builder {
        private Boolean asyncCredentialUpdateEnabled = false;
        private SsoClient ssoClient;
        private Duration staleTime;
        private Duration prefetchTime;
        private Supplier<GetRoleCredentialsRequest> getRoleCredentialsRequestSupplier;

        BuilderImpl() {
        }

        public BuilderImpl(SsoCredentialsProvider provider) {
            this.asyncCredentialUpdateEnabled = provider.asyncCredentialUpdateEnabled;
            this.ssoClient = provider.ssoClient;
            this.staleTime = provider.staleTime;
            this.prefetchTime = provider.prefetchTime;
            this.getRoleCredentialsRequestSupplier = provider.getRoleCredentialsRequestSupplier;
        }

        @Override
        public Builder ssoClient(SsoClient ssoClient) {
            this.ssoClient = ssoClient;
            return this;
        }

        @Override
        public Builder asyncCredentialUpdateEnabled(Boolean asyncCredentialUpdateEnabled) {
            this.asyncCredentialUpdateEnabled = asyncCredentialUpdateEnabled;
            return this;
        }

        @Override
        public Builder staleTime(Duration staleTime) {
            this.staleTime = staleTime;
            return this;
        }

        @Override
        public Builder prefetchTime(Duration prefetchTime) {
            this.prefetchTime = prefetchTime;
            return this;
        }

        @Override
        public Builder refreshRequest(GetRoleCredentialsRequest getRoleCredentialsRequest) {
            return this.refreshRequest(() -> getRoleCredentialsRequest);
        }

        @Override
        public Builder refreshRequest(Supplier<GetRoleCredentialsRequest> getRoleCredentialsRequestSupplier) {
            this.getRoleCredentialsRequestSupplier = getRoleCredentialsRequestSupplier;
            return this;
        }

        @Override
        public SsoCredentialsProvider build() {
            return new SsoCredentialsProvider(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, SsoCredentialsProvider> {
        public Builder ssoClient(SsoClient var1);

        public Builder asyncCredentialUpdateEnabled(Boolean var1);

        public Builder staleTime(Duration var1);

        public Builder prefetchTime(Duration var1);

        public Builder refreshRequest(GetRoleCredentialsRequest var1);

        public Builder refreshRequest(Supplier<GetRoleCredentialsRequest> var1);

        public SsoCredentialsProvider build();
    }
}

