/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.swf.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.swf.SwfAsyncClient;
import software.amazon.awssdk.services.swf.model.ActivityTypeInfo;
import software.amazon.awssdk.services.swf.model.ListActivityTypesRequest;
import software.amazon.awssdk.services.swf.model.ListActivityTypesResponse;

public class ListActivityTypesPublisher
implements SdkPublisher<ListActivityTypesResponse> {
    private final SwfAsyncClient client;
    private final ListActivityTypesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListActivityTypesPublisher(SwfAsyncClient client, ListActivityTypesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListActivityTypesPublisher(SwfAsyncClient client, ListActivityTypesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListActivityTypesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListActivityTypesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ActivityTypeInfo> typeInfos() {
        Function<ListActivityTypesResponse, Iterator> getIterator = response -> {
            if (response != null && response.typeInfos() != null) {
                return response.typeInfos().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListActivityTypesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListActivityTypesResponseFetcher
    implements AsyncPageFetcher<ListActivityTypesResponse> {
        private ListActivityTypesResponseFetcher() {
        }

        public boolean hasNextPage(ListActivityTypesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextPageToken());
        }

        public CompletableFuture<ListActivityTypesResponse> nextPage(ListActivityTypesResponse previousPage) {
            if (previousPage == null) {
                return ListActivityTypesPublisher.this.client.listActivityTypes(ListActivityTypesPublisher.this.firstRequest);
            }
            return ListActivityTypesPublisher.this.client.listActivityTypes((ListActivityTypesRequest)((Object)ListActivityTypesPublisher.this.firstRequest.toBuilder().nextPageToken(previousPage.nextPageToken()).build()));
        }
    }
}

