/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.transcribe.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.transcribe.model.TranscribeResponse;
import software.amazon.awssdk.services.transcribe.model.VocabulariesCopier;
import software.amazon.awssdk.services.transcribe.model.VocabularyInfo;
import software.amazon.awssdk.services.transcribe.model.VocabularyState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListVocabulariesResponse
extends TranscribeResponse
implements ToCopyableBuilder<Builder, ListVocabulariesResponse> {
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(ListVocabulariesResponse.getter(ListVocabulariesResponse::statusAsString)).setter(ListVocabulariesResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListVocabulariesResponse.getter(ListVocabulariesResponse::nextToken)).setter(ListVocabulariesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<List<VocabularyInfo>> VOCABULARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Vocabularies").getter(ListVocabulariesResponse.getter(ListVocabulariesResponse::vocabularies)).setter(ListVocabulariesResponse.setter(Builder::vocabularies)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Vocabularies").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(VocabularyInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD, NEXT_TOKEN_FIELD, VOCABULARIES_FIELD));
    private final String status;
    private final String nextToken;
    private final List<VocabularyInfo> vocabularies;

    private ListVocabulariesResponse(BuilderImpl builder) {
        super(builder);
        this.status = builder.status;
        this.nextToken = builder.nextToken;
        this.vocabularies = builder.vocabularies;
    }

    public VocabularyState status() {
        return VocabularyState.fromValue(this.status);
    }

    public String statusAsString() {
        return this.status;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public boolean hasVocabularies() {
        return this.vocabularies != null && !(this.vocabularies instanceof SdkAutoConstructList);
    }

    public List<VocabularyInfo> vocabularies() {
        return this.vocabularies;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasVocabularies() ? this.vocabularies() : null);
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListVocabulariesResponse)) {
            return false;
        }
        ListVocabulariesResponse other = (ListVocabulariesResponse)((Object)obj);
        return Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.nextToken(), other.nextToken()) && this.hasVocabularies() == other.hasVocabularies() && Objects.equals(this.vocabularies(), other.vocabularies());
    }

    public String toString() {
        return ToString.builder((String)"ListVocabulariesResponse").add("Status", (Object)this.statusAsString()).add("NextToken", (Object)this.nextToken()).add("Vocabularies", this.hasVocabularies() ? this.vocabularies() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "Vocabularies": {
                return Optional.ofNullable(clazz.cast(this.vocabularies()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListVocabulariesResponse, T> g) {
        return obj -> g.apply((ListVocabulariesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends TranscribeResponse.BuilderImpl
    implements Builder {
        private String status;
        private String nextToken;
        private List<VocabularyInfo> vocabularies = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListVocabulariesResponse model) {
            super(model);
            this.status(model.status);
            this.nextToken(model.nextToken);
            this.vocabularies(model.vocabularies);
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(VocabularyState status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<VocabularyInfo.Builder> getVocabularies() {
            if (this.vocabularies instanceof SdkAutoConstructList) {
                return null;
            }
            return this.vocabularies != null ? (Collection)this.vocabularies.stream().map(VocabularyInfo::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder vocabularies(Collection<VocabularyInfo> vocabularies) {
            this.vocabularies = VocabulariesCopier.copy(vocabularies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vocabularies(VocabularyInfo ... vocabularies) {
            this.vocabularies(Arrays.asList(vocabularies));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vocabularies(Consumer<VocabularyInfo.Builder> ... vocabularies) {
            this.vocabularies(Stream.of(vocabularies).map(c -> (VocabularyInfo)((VocabularyInfo.Builder)VocabularyInfo.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setVocabularies(Collection<VocabularyInfo.BuilderImpl> vocabularies) {
            this.vocabularies = VocabulariesCopier.copyFromBuilder(vocabularies);
        }

        @Override
        public ListVocabulariesResponse build() {
            return new ListVocabulariesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends TranscribeResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListVocabulariesResponse> {
        public Builder status(String var1);

        public Builder status(VocabularyState var1);

        public Builder nextToken(String var1);

        public Builder vocabularies(Collection<VocabularyInfo> var1);

        public Builder vocabularies(VocabularyInfo ... var1);

        public Builder vocabularies(Consumer<VocabularyInfo.Builder> ... var1);
    }
}

