/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.transcribe.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides detailed information about a specific Call Analytics job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CallAnalyticsJobSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<CallAnalyticsJobSummary.Builder, CallAnalyticsJobSummary> {
    private static final SdkField<String> CALL_ANALYTICS_JOB_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CallAnalyticsJobName").getter(getter(CallAnalyticsJobSummary::callAnalyticsJobName))
            .setter(setter(Builder::callAnalyticsJobName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CallAnalyticsJobName").build())
            .build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime").getter(getter(CallAnalyticsJobSummary::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("StartTime").getter(getter(CallAnalyticsJobSummary::startTime)).setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()).build();

    private static final SdkField<Instant> COMPLETION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CompletionTime").getter(getter(CallAnalyticsJobSummary::completionTime))
            .setter(setter(Builder::completionTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompletionTime").build()).build();

    private static final SdkField<String> LANGUAGE_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LanguageCode").getter(getter(CallAnalyticsJobSummary::languageCodeAsString))
            .setter(setter(Builder::languageCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LanguageCode").build()).build();

    private static final SdkField<String> CALL_ANALYTICS_JOB_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CallAnalyticsJobStatus").getter(getter(CallAnalyticsJobSummary::callAnalyticsJobStatusAsString))
            .setter(setter(Builder::callAnalyticsJobStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CallAnalyticsJobStatus").build())
            .build();

    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FailureReason").getter(getter(CallAnalyticsJobSummary::failureReason))
            .setter(setter(Builder::failureReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureReason").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CALL_ANALYTICS_JOB_NAME_FIELD,
            CREATION_TIME_FIELD, START_TIME_FIELD, COMPLETION_TIME_FIELD, LANGUAGE_CODE_FIELD, CALL_ANALYTICS_JOB_STATUS_FIELD,
            FAILURE_REASON_FIELD));

    private static final long serialVersionUID = 1L;

    private final String callAnalyticsJobName;

    private final Instant creationTime;

    private final Instant startTime;

    private final Instant completionTime;

    private final String languageCode;

    private final String callAnalyticsJobStatus;

    private final String failureReason;

    private CallAnalyticsJobSummary(BuilderImpl builder) {
        this.callAnalyticsJobName = builder.callAnalyticsJobName;
        this.creationTime = builder.creationTime;
        this.startTime = builder.startTime;
        this.completionTime = builder.completionTime;
        this.languageCode = builder.languageCode;
        this.callAnalyticsJobStatus = builder.callAnalyticsJobStatus;
        this.failureReason = builder.failureReason;
    }

    /**
     * <p>
     * The name of the Call Analytics job. Job names are case sensitive and must be unique within an Amazon Web Services
     * account.
     * </p>
     * 
     * @return The name of the Call Analytics job. Job names are case sensitive and must be unique within an Amazon Web
     *         Services account.
     */
    public final String callAnalyticsJobName() {
        return callAnalyticsJobName;
    }

    /**
     * <p>
     * The date and time the specified Call Analytics job request was made.
     * </p>
     * <p>
     * Timestamps are in the format <code>YYYY-MM-DD'T'HH:MM:SS.SSSSSS-UTC</code>. For example,
     * <code>2022-05-04T12:32:58.761000-07:00</code> represents a transcription job that started processing at 12:32 PM
     * UTC-7 on May 4, 2022.
     * </p>
     * 
     * @return The date and time the specified Call Analytics job request was made.</p>
     *         <p>
     *         Timestamps are in the format <code>YYYY-MM-DD'T'HH:MM:SS.SSSSSS-UTC</code>. For example,
     *         <code>2022-05-04T12:32:58.761000-07:00</code> represents a transcription job that started processing at
     *         12:32 PM UTC-7 on May 4, 2022.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The date and time your Call Analytics job began processing.
     * </p>
     * <p>
     * Timestamps are in the format <code>YYYY-MM-DD'T'HH:MM:SS.SSSSSS-UTC</code>. For example,
     * <code>2022-05-04T12:32:58.789000-07:00</code> represents a transcription job that started processing at 12:32 PM
     * UTC-7 on May 4, 2022.
     * </p>
     * 
     * @return The date and time your Call Analytics job began processing.</p>
     *         <p>
     *         Timestamps are in the format <code>YYYY-MM-DD'T'HH:MM:SS.SSSSSS-UTC</code>. For example,
     *         <code>2022-05-04T12:32:58.789000-07:00</code> represents a transcription job that started processing at
     *         12:32 PM UTC-7 on May 4, 2022.
     */
    public final Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * The date and time the specified Call Analytics job finished processing.
     * </p>
     * <p>
     * Timestamps are in the format <code>YYYY-MM-DD'T'HH:MM:SS.SSSSSS-UTC</code>. For example,
     * <code>2022-05-04T12:33:13.922000-07:00</code> represents a transcription job that started processing at 12:33 PM
     * UTC-7 on May 4, 2022.
     * </p>
     * 
     * @return The date and time the specified Call Analytics job finished processing.</p>
     *         <p>
     *         Timestamps are in the format <code>YYYY-MM-DD'T'HH:MM:SS.SSSSSS-UTC</code>. For example,
     *         <code>2022-05-04T12:33:13.922000-07:00</code> represents a transcription job that started processing at
     *         12:33 PM UTC-7 on May 4, 2022.
     */
    public final Instant completionTime() {
        return completionTime;
    }

    /**
     * <p>
     * The language code used to create your Call Analytics transcription.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #languageCode} will
     * return {@link LanguageCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #languageCodeAsString}.
     * </p>
     * 
     * @return The language code used to create your Call Analytics transcription.
     * @see LanguageCode
     */
    public final LanguageCode languageCode() {
        return LanguageCode.fromValue(languageCode);
    }

    /**
     * <p>
     * The language code used to create your Call Analytics transcription.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #languageCode} will
     * return {@link LanguageCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #languageCodeAsString}.
     * </p>
     * 
     * @return The language code used to create your Call Analytics transcription.
     * @see LanguageCode
     */
    public final String languageCodeAsString() {
        return languageCode;
    }

    /**
     * <p>
     * Provides the status of your Call Analytics job.
     * </p>
     * <p>
     * If the status is <code>COMPLETED</code>, the job is finished and you can find the results at the location
     * specified in <code>TranscriptFileUri</code> (or <code>RedactedTranscriptFileUri</code>, if you requested
     * transcript redaction). If the status is <code>FAILED</code>, <code>FailureReason</code> provides details on why
     * your transcription job failed.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #callAnalyticsJobStatus} will return {@link CallAnalyticsJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #callAnalyticsJobStatusAsString}.
     * </p>
     * 
     * @return Provides the status of your Call Analytics job.</p>
     *         <p>
     *         If the status is <code>COMPLETED</code>, the job is finished and you can find the results at the location
     *         specified in <code>TranscriptFileUri</code> (or <code>RedactedTranscriptFileUri</code>, if you requested
     *         transcript redaction). If the status is <code>FAILED</code>, <code>FailureReason</code> provides details
     *         on why your transcription job failed.
     * @see CallAnalyticsJobStatus
     */
    public final CallAnalyticsJobStatus callAnalyticsJobStatus() {
        return CallAnalyticsJobStatus.fromValue(callAnalyticsJobStatus);
    }

    /**
     * <p>
     * Provides the status of your Call Analytics job.
     * </p>
     * <p>
     * If the status is <code>COMPLETED</code>, the job is finished and you can find the results at the location
     * specified in <code>TranscriptFileUri</code> (or <code>RedactedTranscriptFileUri</code>, if you requested
     * transcript redaction). If the status is <code>FAILED</code>, <code>FailureReason</code> provides details on why
     * your transcription job failed.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #callAnalyticsJobStatus} will return {@link CallAnalyticsJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #callAnalyticsJobStatusAsString}.
     * </p>
     * 
     * @return Provides the status of your Call Analytics job.</p>
     *         <p>
     *         If the status is <code>COMPLETED</code>, the job is finished and you can find the results at the location
     *         specified in <code>TranscriptFileUri</code> (or <code>RedactedTranscriptFileUri</code>, if you requested
     *         transcript redaction). If the status is <code>FAILED</code>, <code>FailureReason</code> provides details
     *         on why your transcription job failed.
     * @see CallAnalyticsJobStatus
     */
    public final String callAnalyticsJobStatusAsString() {
        return callAnalyticsJobStatus;
    }

    /**
     * <p>
     * If <code>CallAnalyticsJobStatus</code> is <code>FAILED</code>, <code>FailureReason</code> contains information
     * about why the Call Analytics job failed. See also: <a
     * href="https://docs.aws.amazon.com/transcribe/latest/APIReference/CommonErrors.html">Common Errors</a>.
     * </p>
     * 
     * @return If <code>CallAnalyticsJobStatus</code> is <code>FAILED</code>, <code>FailureReason</code> contains
     *         information about why the Call Analytics job failed. See also: <a
     *         href="https://docs.aws.amazon.com/transcribe/latest/APIReference/CommonErrors.html">Common Errors</a>.
     */
    public final String failureReason() {
        return failureReason;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(callAnalyticsJobName());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(completionTime());
        hashCode = 31 * hashCode + Objects.hashCode(languageCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(callAnalyticsJobStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(failureReason());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CallAnalyticsJobSummary)) {
            return false;
        }
        CallAnalyticsJobSummary other = (CallAnalyticsJobSummary) obj;
        return Objects.equals(callAnalyticsJobName(), other.callAnalyticsJobName())
                && Objects.equals(creationTime(), other.creationTime()) && Objects.equals(startTime(), other.startTime())
                && Objects.equals(completionTime(), other.completionTime())
                && Objects.equals(languageCodeAsString(), other.languageCodeAsString())
                && Objects.equals(callAnalyticsJobStatusAsString(), other.callAnalyticsJobStatusAsString())
                && Objects.equals(failureReason(), other.failureReason());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CallAnalyticsJobSummary").add("CallAnalyticsJobName", callAnalyticsJobName())
                .add("CreationTime", creationTime()).add("StartTime", startTime()).add("CompletionTime", completionTime())
                .add("LanguageCode", languageCodeAsString()).add("CallAnalyticsJobStatus", callAnalyticsJobStatusAsString())
                .add("FailureReason", failureReason()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CallAnalyticsJobName":
            return Optional.ofNullable(clazz.cast(callAnalyticsJobName()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "StartTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "CompletionTime":
            return Optional.ofNullable(clazz.cast(completionTime()));
        case "LanguageCode":
            return Optional.ofNullable(clazz.cast(languageCodeAsString()));
        case "CallAnalyticsJobStatus":
            return Optional.ofNullable(clazz.cast(callAnalyticsJobStatusAsString()));
        case "FailureReason":
            return Optional.ofNullable(clazz.cast(failureReason()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CallAnalyticsJobSummary, T> g) {
        return obj -> g.apply((CallAnalyticsJobSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CallAnalyticsJobSummary> {
        /**
         * <p>
         * The name of the Call Analytics job. Job names are case sensitive and must be unique within an Amazon Web
         * Services account.
         * </p>
         * 
         * @param callAnalyticsJobName
         *        The name of the Call Analytics job. Job names are case sensitive and must be unique within an Amazon
         *        Web Services account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder callAnalyticsJobName(String callAnalyticsJobName);

        /**
         * <p>
         * The date and time the specified Call Analytics job request was made.
         * </p>
         * <p>
         * Timestamps are in the format <code>YYYY-MM-DD'T'HH:MM:SS.SSSSSS-UTC</code>. For example,
         * <code>2022-05-04T12:32:58.761000-07:00</code> represents a transcription job that started processing at 12:32
         * PM UTC-7 on May 4, 2022.
         * </p>
         * 
         * @param creationTime
         *        The date and time the specified Call Analytics job request was made.</p>
         *        <p>
         *        Timestamps are in the format <code>YYYY-MM-DD'T'HH:MM:SS.SSSSSS-UTC</code>. For example,
         *        <code>2022-05-04T12:32:58.761000-07:00</code> represents a transcription job that started processing
         *        at 12:32 PM UTC-7 on May 4, 2022.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The date and time your Call Analytics job began processing.
         * </p>
         * <p>
         * Timestamps are in the format <code>YYYY-MM-DD'T'HH:MM:SS.SSSSSS-UTC</code>. For example,
         * <code>2022-05-04T12:32:58.789000-07:00</code> represents a transcription job that started processing at 12:32
         * PM UTC-7 on May 4, 2022.
         * </p>
         * 
         * @param startTime
         *        The date and time your Call Analytics job began processing.</p>
         *        <p>
         *        Timestamps are in the format <code>YYYY-MM-DD'T'HH:MM:SS.SSSSSS-UTC</code>. For example,
         *        <code>2022-05-04T12:32:58.789000-07:00</code> represents a transcription job that started processing
         *        at 12:32 PM UTC-7 on May 4, 2022.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * The date and time the specified Call Analytics job finished processing.
         * </p>
         * <p>
         * Timestamps are in the format <code>YYYY-MM-DD'T'HH:MM:SS.SSSSSS-UTC</code>. For example,
         * <code>2022-05-04T12:33:13.922000-07:00</code> represents a transcription job that started processing at 12:33
         * PM UTC-7 on May 4, 2022.
         * </p>
         * 
         * @param completionTime
         *        The date and time the specified Call Analytics job finished processing.</p>
         *        <p>
         *        Timestamps are in the format <code>YYYY-MM-DD'T'HH:MM:SS.SSSSSS-UTC</code>. For example,
         *        <code>2022-05-04T12:33:13.922000-07:00</code> represents a transcription job that started processing
         *        at 12:33 PM UTC-7 on May 4, 2022.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder completionTime(Instant completionTime);

        /**
         * <p>
         * The language code used to create your Call Analytics transcription.
         * </p>
         * 
         * @param languageCode
         *        The language code used to create your Call Analytics transcription.
         * @see LanguageCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LanguageCode
         */
        Builder languageCode(String languageCode);

        /**
         * <p>
         * The language code used to create your Call Analytics transcription.
         * </p>
         * 
         * @param languageCode
         *        The language code used to create your Call Analytics transcription.
         * @see LanguageCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LanguageCode
         */
        Builder languageCode(LanguageCode languageCode);

        /**
         * <p>
         * Provides the status of your Call Analytics job.
         * </p>
         * <p>
         * If the status is <code>COMPLETED</code>, the job is finished and you can find the results at the location
         * specified in <code>TranscriptFileUri</code> (or <code>RedactedTranscriptFileUri</code>, if you requested
         * transcript redaction). If the status is <code>FAILED</code>, <code>FailureReason</code> provides details on
         * why your transcription job failed.
         * </p>
         * 
         * @param callAnalyticsJobStatus
         *        Provides the status of your Call Analytics job.</p>
         *        <p>
         *        If the status is <code>COMPLETED</code>, the job is finished and you can find the results at the
         *        location specified in <code>TranscriptFileUri</code> (or <code>RedactedTranscriptFileUri</code>, if
         *        you requested transcript redaction). If the status is <code>FAILED</code>, <code>FailureReason</code>
         *        provides details on why your transcription job failed.
         * @see CallAnalyticsJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CallAnalyticsJobStatus
         */
        Builder callAnalyticsJobStatus(String callAnalyticsJobStatus);

        /**
         * <p>
         * Provides the status of your Call Analytics job.
         * </p>
         * <p>
         * If the status is <code>COMPLETED</code>, the job is finished and you can find the results at the location
         * specified in <code>TranscriptFileUri</code> (or <code>RedactedTranscriptFileUri</code>, if you requested
         * transcript redaction). If the status is <code>FAILED</code>, <code>FailureReason</code> provides details on
         * why your transcription job failed.
         * </p>
         * 
         * @param callAnalyticsJobStatus
         *        Provides the status of your Call Analytics job.</p>
         *        <p>
         *        If the status is <code>COMPLETED</code>, the job is finished and you can find the results at the
         *        location specified in <code>TranscriptFileUri</code> (or <code>RedactedTranscriptFileUri</code>, if
         *        you requested transcript redaction). If the status is <code>FAILED</code>, <code>FailureReason</code>
         *        provides details on why your transcription job failed.
         * @see CallAnalyticsJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CallAnalyticsJobStatus
         */
        Builder callAnalyticsJobStatus(CallAnalyticsJobStatus callAnalyticsJobStatus);

        /**
         * <p>
         * If <code>CallAnalyticsJobStatus</code> is <code>FAILED</code>, <code>FailureReason</code> contains
         * information about why the Call Analytics job failed. See also: <a
         * href="https://docs.aws.amazon.com/transcribe/latest/APIReference/CommonErrors.html">Common Errors</a>.
         * </p>
         * 
         * @param failureReason
         *        If <code>CallAnalyticsJobStatus</code> is <code>FAILED</code>, <code>FailureReason</code> contains
         *        information about why the Call Analytics job failed. See also: <a
         *        href="https://docs.aws.amazon.com/transcribe/latest/APIReference/CommonErrors.html">Common Errors</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureReason(String failureReason);
    }

    static final class BuilderImpl implements Builder {
        private String callAnalyticsJobName;

        private Instant creationTime;

        private Instant startTime;

        private Instant completionTime;

        private String languageCode;

        private String callAnalyticsJobStatus;

        private String failureReason;

        private BuilderImpl() {
        }

        private BuilderImpl(CallAnalyticsJobSummary model) {
            callAnalyticsJobName(model.callAnalyticsJobName);
            creationTime(model.creationTime);
            startTime(model.startTime);
            completionTime(model.completionTime);
            languageCode(model.languageCode);
            callAnalyticsJobStatus(model.callAnalyticsJobStatus);
            failureReason(model.failureReason);
        }

        public final String getCallAnalyticsJobName() {
            return callAnalyticsJobName;
        }

        public final void setCallAnalyticsJobName(String callAnalyticsJobName) {
            this.callAnalyticsJobName = callAnalyticsJobName;
        }

        @Override
        public final Builder callAnalyticsJobName(String callAnalyticsJobName) {
            this.callAnalyticsJobName = callAnalyticsJobName;
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getCompletionTime() {
            return completionTime;
        }

        public final void setCompletionTime(Instant completionTime) {
            this.completionTime = completionTime;
        }

        @Override
        public final Builder completionTime(Instant completionTime) {
            this.completionTime = completionTime;
            return this;
        }

        public final String getLanguageCode() {
            return languageCode;
        }

        public final void setLanguageCode(String languageCode) {
            this.languageCode = languageCode;
        }

        @Override
        public final Builder languageCode(String languageCode) {
            this.languageCode = languageCode;
            return this;
        }

        @Override
        public final Builder languageCode(LanguageCode languageCode) {
            this.languageCode(languageCode == null ? null : languageCode.toString());
            return this;
        }

        public final String getCallAnalyticsJobStatus() {
            return callAnalyticsJobStatus;
        }

        public final void setCallAnalyticsJobStatus(String callAnalyticsJobStatus) {
            this.callAnalyticsJobStatus = callAnalyticsJobStatus;
        }

        @Override
        public final Builder callAnalyticsJobStatus(String callAnalyticsJobStatus) {
            this.callAnalyticsJobStatus = callAnalyticsJobStatus;
            return this;
        }

        @Override
        public final Builder callAnalyticsJobStatus(CallAnalyticsJobStatus callAnalyticsJobStatus) {
            this.callAnalyticsJobStatus(callAnalyticsJobStatus == null ? null : callAnalyticsJobStatus.toString());
            return this;
        }

        public final String getFailureReason() {
            return failureReason;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        @Override
        public CallAnalyticsJobSummary build() {
            return new CallAnalyticsJobSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
