/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.transcribestreaming.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum ItemType {
    PRONUNCIATION("PRONUNCIATION"),
    PUNCTUATION("PUNCTUATION"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private ItemType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ItemType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(ItemType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ItemType> knownValues() {
        return Stream.of(ItemType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

