/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workdocs.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum ResourceCollectionType {
    SHARED_WITH_ME("SHARED_WITH_ME"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private ResourceCollectionType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ResourceCollectionType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(ResourceCollectionType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ResourceCollectionType> knownValues() {
        return Stream.of(ResourceCollectionType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

