/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workdocs.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.workdocs.model.DocumentVersionMetadata;
import software.amazon.awssdk.services.workdocs.model.ResourceStateType;
import software.amazon.awssdk.services.workdocs.model.SharedLabelsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DocumentMetadata
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DocumentMetadata> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(DocumentMetadata.getter(DocumentMetadata::id)).setter(DocumentMetadata.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<String> CREATOR_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CreatorId").getter(DocumentMetadata.getter(DocumentMetadata::creatorId)).setter(DocumentMetadata.setter(Builder::creatorId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatorId").build()}).build();
    private static final SdkField<String> PARENT_FOLDER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ParentFolderId").getter(DocumentMetadata.getter(DocumentMetadata::parentFolderId)).setter(DocumentMetadata.setter(Builder::parentFolderId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParentFolderId").build()}).build();
    private static final SdkField<Instant> CREATED_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedTimestamp").getter(DocumentMetadata.getter(DocumentMetadata::createdTimestamp)).setter(DocumentMetadata.setter(Builder::createdTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTimestamp").build()}).build();
    private static final SdkField<Instant> MODIFIED_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ModifiedTimestamp").getter(DocumentMetadata.getter(DocumentMetadata::modifiedTimestamp)).setter(DocumentMetadata.setter(Builder::modifiedTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModifiedTimestamp").build()}).build();
    private static final SdkField<DocumentVersionMetadata> LATEST_VERSION_METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LatestVersionMetadata").getter(DocumentMetadata.getter(DocumentMetadata::latestVersionMetadata)).setter(DocumentMetadata.setter(Builder::latestVersionMetadata)).constructor(DocumentVersionMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LatestVersionMetadata").build()}).build();
    private static final SdkField<String> RESOURCE_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceState").getter(DocumentMetadata.getter(DocumentMetadata::resourceStateAsString)).setter(DocumentMetadata.setter(Builder::resourceState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceState").build()}).build();
    private static final SdkField<List<String>> LABELS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Labels").getter(DocumentMetadata.getter(DocumentMetadata::labels)).setter(DocumentMetadata.setter(Builder::labels)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Labels").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, CREATOR_ID_FIELD, PARENT_FOLDER_ID_FIELD, CREATED_TIMESTAMP_FIELD, MODIFIED_TIMESTAMP_FIELD, LATEST_VERSION_METADATA_FIELD, RESOURCE_STATE_FIELD, LABELS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String id;
    private final String creatorId;
    private final String parentFolderId;
    private final Instant createdTimestamp;
    private final Instant modifiedTimestamp;
    private final DocumentVersionMetadata latestVersionMetadata;
    private final String resourceState;
    private final List<String> labels;

    private DocumentMetadata(BuilderImpl builder) {
        this.id = builder.id;
        this.creatorId = builder.creatorId;
        this.parentFolderId = builder.parentFolderId;
        this.createdTimestamp = builder.createdTimestamp;
        this.modifiedTimestamp = builder.modifiedTimestamp;
        this.latestVersionMetadata = builder.latestVersionMetadata;
        this.resourceState = builder.resourceState;
        this.labels = builder.labels;
    }

    public final String id() {
        return this.id;
    }

    public final String creatorId() {
        return this.creatorId;
    }

    public final String parentFolderId() {
        return this.parentFolderId;
    }

    public final Instant createdTimestamp() {
        return this.createdTimestamp;
    }

    public final Instant modifiedTimestamp() {
        return this.modifiedTimestamp;
    }

    public final DocumentVersionMetadata latestVersionMetadata() {
        return this.latestVersionMetadata;
    }

    public final ResourceStateType resourceState() {
        return ResourceStateType.fromValue(this.resourceState);
    }

    public final String resourceStateAsString() {
        return this.resourceState;
    }

    public final boolean hasLabels() {
        return this.labels != null && !(this.labels instanceof SdkAutoConstructList);
    }

    public final List<String> labels() {
        return this.labels;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.creatorId());
        hashCode = 31 * hashCode + Objects.hashCode(this.parentFolderId());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.modifiedTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.latestVersionMetadata());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLabels() ? this.labels() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DocumentMetadata)) {
            return false;
        }
        DocumentMetadata other = (DocumentMetadata)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.creatorId(), other.creatorId()) && Objects.equals(this.parentFolderId(), other.parentFolderId()) && Objects.equals(this.createdTimestamp(), other.createdTimestamp()) && Objects.equals(this.modifiedTimestamp(), other.modifiedTimestamp()) && Objects.equals(this.latestVersionMetadata(), other.latestVersionMetadata()) && Objects.equals(this.resourceStateAsString(), other.resourceStateAsString()) && this.hasLabels() == other.hasLabels() && Objects.equals(this.labels(), other.labels());
    }

    public final String toString() {
        return ToString.builder((String)"DocumentMetadata").add("Id", (Object)this.id()).add("CreatorId", (Object)this.creatorId()).add("ParentFolderId", (Object)this.parentFolderId()).add("CreatedTimestamp", (Object)this.createdTimestamp()).add("ModifiedTimestamp", (Object)this.modifiedTimestamp()).add("LatestVersionMetadata", (Object)this.latestVersionMetadata()).add("ResourceState", (Object)this.resourceStateAsString()).add("Labels", this.hasLabels() ? this.labels() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "CreatorId": {
                return Optional.ofNullable(clazz.cast(this.creatorId()));
            }
            case "ParentFolderId": {
                return Optional.ofNullable(clazz.cast(this.parentFolderId()));
            }
            case "CreatedTimestamp": {
                return Optional.ofNullable(clazz.cast(this.createdTimestamp()));
            }
            case "ModifiedTimestamp": {
                return Optional.ofNullable(clazz.cast(this.modifiedTimestamp()));
            }
            case "LatestVersionMetadata": {
                return Optional.ofNullable(clazz.cast(this.latestVersionMetadata()));
            }
            case "ResourceState": {
                return Optional.ofNullable(clazz.cast(this.resourceStateAsString()));
            }
            case "Labels": {
                return Optional.ofNullable(clazz.cast(this.labels()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DocumentMetadata, T> g) {
        return obj -> g.apply((DocumentMetadata)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String creatorId;
        private String parentFolderId;
        private Instant createdTimestamp;
        private Instant modifiedTimestamp;
        private DocumentVersionMetadata latestVersionMetadata;
        private String resourceState;
        private List<String> labels = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DocumentMetadata model) {
            this.id(model.id);
            this.creatorId(model.creatorId);
            this.parentFolderId(model.parentFolderId);
            this.createdTimestamp(model.createdTimestamp);
            this.modifiedTimestamp(model.modifiedTimestamp);
            this.latestVersionMetadata(model.latestVersionMetadata);
            this.resourceState(model.resourceState);
            this.labels(model.labels);
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getCreatorId() {
            return this.creatorId;
        }

        @Override
        public final Builder creatorId(String creatorId) {
            this.creatorId = creatorId;
            return this;
        }

        public final void setCreatorId(String creatorId) {
            this.creatorId = creatorId;
        }

        public final String getParentFolderId() {
            return this.parentFolderId;
        }

        @Override
        public final Builder parentFolderId(String parentFolderId) {
            this.parentFolderId = parentFolderId;
            return this;
        }

        public final void setParentFolderId(String parentFolderId) {
            this.parentFolderId = parentFolderId;
        }

        public final Instant getCreatedTimestamp() {
            return this.createdTimestamp;
        }

        @Override
        public final Builder createdTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
            return this;
        }

        public final void setCreatedTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
        }

        public final Instant getModifiedTimestamp() {
            return this.modifiedTimestamp;
        }

        @Override
        public final Builder modifiedTimestamp(Instant modifiedTimestamp) {
            this.modifiedTimestamp = modifiedTimestamp;
            return this;
        }

        public final void setModifiedTimestamp(Instant modifiedTimestamp) {
            this.modifiedTimestamp = modifiedTimestamp;
        }

        public final DocumentVersionMetadata.Builder getLatestVersionMetadata() {
            return this.latestVersionMetadata != null ? this.latestVersionMetadata.toBuilder() : null;
        }

        @Override
        public final Builder latestVersionMetadata(DocumentVersionMetadata latestVersionMetadata) {
            this.latestVersionMetadata = latestVersionMetadata;
            return this;
        }

        public final void setLatestVersionMetadata(DocumentVersionMetadata.BuilderImpl latestVersionMetadata) {
            this.latestVersionMetadata = latestVersionMetadata != null ? latestVersionMetadata.build() : null;
        }

        public final String getResourceState() {
            return this.resourceState;
        }

        @Override
        public final Builder resourceState(String resourceState) {
            this.resourceState = resourceState;
            return this;
        }

        @Override
        public final Builder resourceState(ResourceStateType resourceState) {
            this.resourceState(resourceState == null ? null : resourceState.toString());
            return this;
        }

        public final void setResourceState(String resourceState) {
            this.resourceState = resourceState;
        }

        public final Collection<String> getLabels() {
            if (this.labels instanceof SdkAutoConstructList) {
                return null;
            }
            return this.labels;
        }

        @Override
        public final Builder labels(Collection<String> labels) {
            this.labels = SharedLabelsCopier.copy(labels);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder labels(String ... labels) {
            this.labels(Arrays.asList(labels));
            return this;
        }

        public final void setLabels(Collection<String> labels) {
            this.labels = SharedLabelsCopier.copy(labels);
        }

        public DocumentMetadata build() {
            return new DocumentMetadata(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DocumentMetadata> {
        public Builder id(String var1);

        public Builder creatorId(String var1);

        public Builder parentFolderId(String var1);

        public Builder createdTimestamp(Instant var1);

        public Builder modifiedTimestamp(Instant var1);

        public Builder latestVersionMetadata(DocumentVersionMetadata var1);

        default public Builder latestVersionMetadata(Consumer<DocumentVersionMetadata.Builder> latestVersionMetadata) {
            return this.latestVersionMetadata((DocumentVersionMetadata)((DocumentVersionMetadata.Builder)DocumentVersionMetadata.builder().applyMutation(latestVersionMetadata)).build());
        }

        public Builder resourceState(String var1);

        public Builder resourceState(ResourceStateType var1);

        public Builder labels(Collection<String> var1);

        public Builder labels(String ... var1);
    }
}

