/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workdocs.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum DocumentSourceType {
    ORIGINAL("ORIGINAL"),
    WITH_COMMENTS("WITH_COMMENTS"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private DocumentSourceType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DocumentSourceType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(DocumentSourceType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DocumentSourceType> knownValues() {
        return Stream.of(DocumentSourceType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

