/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workmail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.workmail.model.OrganizationSummariesCopier;
import software.amazon.awssdk.services.workmail.model.OrganizationSummary;
import software.amazon.awssdk.services.workmail.model.WorkMailResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListOrganizationsResponse
extends WorkMailResponse
implements ToCopyableBuilder<Builder, ListOrganizationsResponse> {
    private static final SdkField<List<OrganizationSummary>> ORGANIZATION_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("OrganizationSummaries").getter(ListOrganizationsResponse.getter(ListOrganizationsResponse::organizationSummaries)).setter(ListOrganizationsResponse.setter(Builder::organizationSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrganizationSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(OrganizationSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListOrganizationsResponse.getter(ListOrganizationsResponse::nextToken)).setter(ListOrganizationsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ORGANIZATION_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListOrganizationsResponse.memberNameToFieldInitializer();
    private final List<OrganizationSummary> organizationSummaries;
    private final String nextToken;

    private ListOrganizationsResponse(BuilderImpl builder) {
        super(builder);
        this.organizationSummaries = builder.organizationSummaries;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasOrganizationSummaries() {
        return this.organizationSummaries != null && !(this.organizationSummaries instanceof SdkAutoConstructList);
    }

    public final List<OrganizationSummary> organizationSummaries() {
        return this.organizationSummaries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOrganizationSummaries() ? this.organizationSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListOrganizationsResponse)) {
            return false;
        }
        ListOrganizationsResponse other = (ListOrganizationsResponse)((Object)obj);
        return this.hasOrganizationSummaries() == other.hasOrganizationSummaries() && Objects.equals(this.organizationSummaries(), other.organizationSummaries()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListOrganizationsResponse").add("OrganizationSummaries", this.hasOrganizationSummaries() ? this.organizationSummaries() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "OrganizationSummaries": {
                return Optional.ofNullable(clazz.cast(this.organizationSummaries()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("OrganizationSummaries", ORGANIZATION_SUMMARIES_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListOrganizationsResponse, T> g) {
        return obj -> g.apply((ListOrganizationsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WorkMailResponse.BuilderImpl
    implements Builder {
        private List<OrganizationSummary> organizationSummaries = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListOrganizationsResponse model) {
            super(model);
            this.organizationSummaries(model.organizationSummaries);
            this.nextToken(model.nextToken);
        }

        public final List<OrganizationSummary.Builder> getOrganizationSummaries() {
            List<OrganizationSummary.Builder> result = OrganizationSummariesCopier.copyToBuilder(this.organizationSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOrganizationSummaries(Collection<OrganizationSummary.BuilderImpl> organizationSummaries) {
            this.organizationSummaries = OrganizationSummariesCopier.copyFromBuilder(organizationSummaries);
        }

        @Override
        public final Builder organizationSummaries(Collection<OrganizationSummary> organizationSummaries) {
            this.organizationSummaries = OrganizationSummariesCopier.copy(organizationSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder organizationSummaries(OrganizationSummary ... organizationSummaries) {
            this.organizationSummaries(Arrays.asList(organizationSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder organizationSummaries(Consumer<OrganizationSummary.Builder> ... organizationSummaries) {
            this.organizationSummaries(Stream.of(organizationSummaries).map(c -> (OrganizationSummary)((OrganizationSummary.Builder)OrganizationSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListOrganizationsResponse build() {
            return new ListOrganizationsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends WorkMailResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListOrganizationsResponse> {
        public Builder organizationSummaries(Collection<OrganizationSummary> var1);

        public Builder organizationSummaries(OrganizationSummary ... var1);

        public Builder organizationSummaries(Consumer<OrganizationSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

