/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.xray.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BackendConnectionErrors implements SdkPojo, Serializable,
        ToCopyableBuilder<BackendConnectionErrors.Builder, BackendConnectionErrors> {
    private static final SdkField<Integer> TIMEOUT_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(BackendConnectionErrors::timeoutCount)).setter(setter(Builder::timeoutCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeoutCount").build()).build();

    private static final SdkField<Integer> CONNECTION_REFUSED_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(BackendConnectionErrors::connectionRefusedCount)).setter(setter(Builder::connectionRefusedCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionRefusedCount").build())
            .build();

    private static final SdkField<Integer> HTTP_CODE4_XX_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(BackendConnectionErrors::httpCode4XXCount)).setter(setter(Builder::httpCode4XXCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HTTPCode4XXCount").build()).build();

    private static final SdkField<Integer> HTTP_CODE5_XX_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(BackendConnectionErrors::httpCode5XXCount)).setter(setter(Builder::httpCode5XXCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HTTPCode5XXCount").build()).build();

    private static final SdkField<Integer> UNKNOWN_HOST_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(BackendConnectionErrors::unknownHostCount)).setter(setter(Builder::unknownHostCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UnknownHostCount").build()).build();

    private static final SdkField<Integer> OTHER_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(BackendConnectionErrors::otherCount)).setter(setter(Builder::otherCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OtherCount").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TIMEOUT_COUNT_FIELD,
            CONNECTION_REFUSED_COUNT_FIELD, HTTP_CODE4_XX_COUNT_FIELD, HTTP_CODE5_XX_COUNT_FIELD, UNKNOWN_HOST_COUNT_FIELD,
            OTHER_COUNT_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer timeoutCount;

    private final Integer connectionRefusedCount;

    private final Integer httpCode4XXCount;

    private final Integer httpCode5XXCount;

    private final Integer unknownHostCount;

    private final Integer otherCount;

    private BackendConnectionErrors(BuilderImpl builder) {
        this.timeoutCount = builder.timeoutCount;
        this.connectionRefusedCount = builder.connectionRefusedCount;
        this.httpCode4XXCount = builder.httpCode4XXCount;
        this.httpCode5XXCount = builder.httpCode5XXCount;
        this.unknownHostCount = builder.unknownHostCount;
        this.otherCount = builder.otherCount;
    }

    /**
     * <p/>
     * 
     * @return
     */
    public Integer timeoutCount() {
        return timeoutCount;
    }

    /**
     * <p/>
     * 
     * @return
     */
    public Integer connectionRefusedCount() {
        return connectionRefusedCount;
    }

    /**
     * <p/>
     * 
     * @return
     */
    public Integer httpCode4XXCount() {
        return httpCode4XXCount;
    }

    /**
     * <p/>
     * 
     * @return
     */
    public Integer httpCode5XXCount() {
        return httpCode5XXCount;
    }

    /**
     * <p/>
     * 
     * @return
     */
    public Integer unknownHostCount() {
        return unknownHostCount;
    }

    /**
     * <p/>
     * 
     * @return
     */
    public Integer otherCount() {
        return otherCount;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(timeoutCount());
        hashCode = 31 * hashCode + Objects.hashCode(connectionRefusedCount());
        hashCode = 31 * hashCode + Objects.hashCode(httpCode4XXCount());
        hashCode = 31 * hashCode + Objects.hashCode(httpCode5XXCount());
        hashCode = 31 * hashCode + Objects.hashCode(unknownHostCount());
        hashCode = 31 * hashCode + Objects.hashCode(otherCount());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BackendConnectionErrors)) {
            return false;
        }
        BackendConnectionErrors other = (BackendConnectionErrors) obj;
        return Objects.equals(timeoutCount(), other.timeoutCount())
                && Objects.equals(connectionRefusedCount(), other.connectionRefusedCount())
                && Objects.equals(httpCode4XXCount(), other.httpCode4XXCount())
                && Objects.equals(httpCode5XXCount(), other.httpCode5XXCount())
                && Objects.equals(unknownHostCount(), other.unknownHostCount())
                && Objects.equals(otherCount(), other.otherCount());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("BackendConnectionErrors").add("TimeoutCount", timeoutCount())
                .add("ConnectionRefusedCount", connectionRefusedCount()).add("HTTPCode4XXCount", httpCode4XXCount())
                .add("HTTPCode5XXCount", httpCode5XXCount()).add("UnknownHostCount", unknownHostCount())
                .add("OtherCount", otherCount()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TimeoutCount":
            return Optional.ofNullable(clazz.cast(timeoutCount()));
        case "ConnectionRefusedCount":
            return Optional.ofNullable(clazz.cast(connectionRefusedCount()));
        case "HTTPCode4XXCount":
            return Optional.ofNullable(clazz.cast(httpCode4XXCount()));
        case "HTTPCode5XXCount":
            return Optional.ofNullable(clazz.cast(httpCode5XXCount()));
        case "UnknownHostCount":
            return Optional.ofNullable(clazz.cast(unknownHostCount()));
        case "OtherCount":
            return Optional.ofNullable(clazz.cast(otherCount()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BackendConnectionErrors, T> g) {
        return obj -> g.apply((BackendConnectionErrors) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BackendConnectionErrors> {
        /**
         * <p/>
         * 
         * @param timeoutCount
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeoutCount(Integer timeoutCount);

        /**
         * <p/>
         * 
         * @param connectionRefusedCount
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectionRefusedCount(Integer connectionRefusedCount);

        /**
         * <p/>
         * 
         * @param httpCode4XXCount
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder httpCode4XXCount(Integer httpCode4XXCount);

        /**
         * <p/>
         * 
         * @param httpCode5XXCount
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder httpCode5XXCount(Integer httpCode5XXCount);

        /**
         * <p/>
         * 
         * @param unknownHostCount
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unknownHostCount(Integer unknownHostCount);

        /**
         * <p/>
         * 
         * @param otherCount
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder otherCount(Integer otherCount);
    }

    static final class BuilderImpl implements Builder {
        private Integer timeoutCount;

        private Integer connectionRefusedCount;

        private Integer httpCode4XXCount;

        private Integer httpCode5XXCount;

        private Integer unknownHostCount;

        private Integer otherCount;

        private BuilderImpl() {
        }

        private BuilderImpl(BackendConnectionErrors model) {
            timeoutCount(model.timeoutCount);
            connectionRefusedCount(model.connectionRefusedCount);
            httpCode4XXCount(model.httpCode4XXCount);
            httpCode5XXCount(model.httpCode5XXCount);
            unknownHostCount(model.unknownHostCount);
            otherCount(model.otherCount);
        }

        public final Integer getTimeoutCount() {
            return timeoutCount;
        }

        @Override
        public final Builder timeoutCount(Integer timeoutCount) {
            this.timeoutCount = timeoutCount;
            return this;
        }

        public final void setTimeoutCount(Integer timeoutCount) {
            this.timeoutCount = timeoutCount;
        }

        public final Integer getConnectionRefusedCount() {
            return connectionRefusedCount;
        }

        @Override
        public final Builder connectionRefusedCount(Integer connectionRefusedCount) {
            this.connectionRefusedCount = connectionRefusedCount;
            return this;
        }

        public final void setConnectionRefusedCount(Integer connectionRefusedCount) {
            this.connectionRefusedCount = connectionRefusedCount;
        }

        public final Integer getHttpCode4XXCount() {
            return httpCode4XXCount;
        }

        @Override
        public final Builder httpCode4XXCount(Integer httpCode4XXCount) {
            this.httpCode4XXCount = httpCode4XXCount;
            return this;
        }

        public final void setHttpCode4XXCount(Integer httpCode4XXCount) {
            this.httpCode4XXCount = httpCode4XXCount;
        }

        public final Integer getHttpCode5XXCount() {
            return httpCode5XXCount;
        }

        @Override
        public final Builder httpCode5XXCount(Integer httpCode5XXCount) {
            this.httpCode5XXCount = httpCode5XXCount;
            return this;
        }

        public final void setHttpCode5XXCount(Integer httpCode5XXCount) {
            this.httpCode5XXCount = httpCode5XXCount;
        }

        public final Integer getUnknownHostCount() {
            return unknownHostCount;
        }

        @Override
        public final Builder unknownHostCount(Integer unknownHostCount) {
            this.unknownHostCount = unknownHostCount;
            return this;
        }

        public final void setUnknownHostCount(Integer unknownHostCount) {
            this.unknownHostCount = unknownHostCount;
        }

        public final Integer getOtherCount() {
            return otherCount;
        }

        @Override
        public final Builder otherCount(Integer otherCount) {
            this.otherCount = otherCount;
            return this;
        }

        public final void setOtherCount(Integer otherCount) {
            this.otherCount = otherCount;
        }

        @Override
        public BackendConnectionErrors build() {
            return new BackendConnectionErrors(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
