/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.xray.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A collection of fields identifying the services in a trace summary error.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ErrorRootCauseService implements SdkPojo, Serializable,
        ToCopyableBuilder<ErrorRootCauseService.Builder, ErrorRootCauseService> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ErrorRootCauseService::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<List<String>> NAMES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(ErrorRootCauseService::names))
            .setter(setter(Builder::names))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Names").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ErrorRootCauseService::type)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ErrorRootCauseService::accountId)).setter(setter(Builder::accountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountId").build()).build();

    private static final SdkField<List<ErrorRootCauseEntity>> ENTITY_PATH_FIELD = SdkField
            .<List<ErrorRootCauseEntity>> builder(MarshallingType.LIST)
            .getter(getter(ErrorRootCauseService::entityPath))
            .setter(setter(Builder::entityPath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EntityPath").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ErrorRootCauseEntity> builder(MarshallingType.SDK_POJO)
                                            .constructor(ErrorRootCauseEntity::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> INFERRED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(ErrorRootCauseService::inferred)).setter(setter(Builder::inferred))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Inferred").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, NAMES_FIELD,
            TYPE_FIELD, ACCOUNT_ID_FIELD, ENTITY_PATH_FIELD, INFERRED_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final List<String> names;

    private final String type;

    private final String accountId;

    private final List<ErrorRootCauseEntity> entityPath;

    private final Boolean inferred;

    private ErrorRootCauseService(BuilderImpl builder) {
        this.name = builder.name;
        this.names = builder.names;
        this.type = builder.type;
        this.accountId = builder.accountId;
        this.entityPath = builder.entityPath;
        this.inferred = builder.inferred;
    }

    /**
     * <p>
     * The service name.
     * </p>
     * 
     * @return The service name.
     */
    public String name() {
        return name;
    }

    /**
     * Returns true if the Names property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasNames() {
        return names != null && !(names instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A collection of associated service names.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasNames()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A collection of associated service names.
     */
    public List<String> names() {
        return names;
    }

    /**
     * <p>
     * The type associated to the service.
     * </p>
     * 
     * @return The type associated to the service.
     */
    public String type() {
        return type;
    }

    /**
     * <p>
     * The account ID associated to the service.
     * </p>
     * 
     * @return The account ID associated to the service.
     */
    public String accountId() {
        return accountId;
    }

    /**
     * Returns true if the EntityPath property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasEntityPath() {
        return entityPath != null && !(entityPath instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The path of root cause entities found on the service.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasEntityPath()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The path of root cause entities found on the service.
     */
    public List<ErrorRootCauseEntity> entityPath() {
        return entityPath;
    }

    /**
     * <p>
     * A Boolean value indicating if the service is inferred from the trace.
     * </p>
     * 
     * @return A Boolean value indicating if the service is inferred from the trace.
     */
    public Boolean inferred() {
        return inferred;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(names());
        hashCode = 31 * hashCode + Objects.hashCode(type());
        hashCode = 31 * hashCode + Objects.hashCode(accountId());
        hashCode = 31 * hashCode + Objects.hashCode(entityPath());
        hashCode = 31 * hashCode + Objects.hashCode(inferred());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ErrorRootCauseService)) {
            return false;
        }
        ErrorRootCauseService other = (ErrorRootCauseService) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(names(), other.names())
                && Objects.equals(type(), other.type()) && Objects.equals(accountId(), other.accountId())
                && Objects.equals(entityPath(), other.entityPath()) && Objects.equals(inferred(), other.inferred());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ErrorRootCauseService").add("Name", name()).add("Names", names()).add("Type", type())
                .add("AccountId", accountId()).add("EntityPath", entityPath()).add("Inferred", inferred()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Names":
            return Optional.ofNullable(clazz.cast(names()));
        case "Type":
            return Optional.ofNullable(clazz.cast(type()));
        case "AccountId":
            return Optional.ofNullable(clazz.cast(accountId()));
        case "EntityPath":
            return Optional.ofNullable(clazz.cast(entityPath()));
        case "Inferred":
            return Optional.ofNullable(clazz.cast(inferred()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ErrorRootCauseService, T> g) {
        return obj -> g.apply((ErrorRootCauseService) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ErrorRootCauseService> {
        /**
         * <p>
         * The service name.
         * </p>
         * 
         * @param name
         *        The service name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A collection of associated service names.
         * </p>
         * 
         * @param names
         *        A collection of associated service names.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder names(Collection<String> names);

        /**
         * <p>
         * A collection of associated service names.
         * </p>
         * 
         * @param names
         *        A collection of associated service names.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder names(String... names);

        /**
         * <p>
         * The type associated to the service.
         * </p>
         * 
         * @param type
         *        The type associated to the service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder type(String type);

        /**
         * <p>
         * The account ID associated to the service.
         * </p>
         * 
         * @param accountId
         *        The account ID associated to the service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountId(String accountId);

        /**
         * <p>
         * The path of root cause entities found on the service.
         * </p>
         * 
         * @param entityPath
         *        The path of root cause entities found on the service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entityPath(Collection<ErrorRootCauseEntity> entityPath);

        /**
         * <p>
         * The path of root cause entities found on the service.
         * </p>
         * 
         * @param entityPath
         *        The path of root cause entities found on the service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entityPath(ErrorRootCauseEntity... entityPath);

        /**
         * <p>
         * The path of root cause entities found on the service.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ErrorRootCauseEntity>.Builder} avoiding the
         * need to create one manually via {@link List<ErrorRootCauseEntity>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ErrorRootCauseEntity>.Builder#build()} is called immediately
         * and its result is passed to {@link #entityPath(List<ErrorRootCauseEntity>)}.
         * 
         * @param entityPath
         *        a consumer that will call methods on {@link List<ErrorRootCauseEntity>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #entityPath(List<ErrorRootCauseEntity>)
         */
        Builder entityPath(Consumer<ErrorRootCauseEntity.Builder>... entityPath);

        /**
         * <p>
         * A Boolean value indicating if the service is inferred from the trace.
         * </p>
         * 
         * @param inferred
         *        A Boolean value indicating if the service is inferred from the trace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inferred(Boolean inferred);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private List<String> names = DefaultSdkAutoConstructList.getInstance();

        private String type;

        private String accountId;

        private List<ErrorRootCauseEntity> entityPath = DefaultSdkAutoConstructList.getInstance();

        private Boolean inferred;

        private BuilderImpl() {
        }

        private BuilderImpl(ErrorRootCauseService model) {
            name(model.name);
            names(model.names);
            type(model.type);
            accountId(model.accountId);
            entityPath(model.entityPath);
            inferred(model.inferred);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Collection<String> getNames() {
            return names;
        }

        @Override
        public final Builder names(Collection<String> names) {
            this.names = ServiceNamesCopier.copy(names);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder names(String... names) {
            names(Arrays.asList(names));
            return this;
        }

        public final void setNames(Collection<String> names) {
            this.names = ServiceNamesCopier.copy(names);
        }

        public final String getType() {
            return type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getAccountId() {
            return accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        public final Collection<ErrorRootCauseEntity.Builder> getEntityPath() {
            return entityPath != null ? entityPath.stream().map(ErrorRootCauseEntity::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder entityPath(Collection<ErrorRootCauseEntity> entityPath) {
            this.entityPath = ErrorRootCauseEntityPathCopier.copy(entityPath);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entityPath(ErrorRootCauseEntity... entityPath) {
            entityPath(Arrays.asList(entityPath));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entityPath(Consumer<ErrorRootCauseEntity.Builder>... entityPath) {
            entityPath(Stream.of(entityPath).map(c -> ErrorRootCauseEntity.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setEntityPath(Collection<ErrorRootCauseEntity.BuilderImpl> entityPath) {
            this.entityPath = ErrorRootCauseEntityPathCopier.copyFromBuilder(entityPath);
        }

        public final Boolean getInferred() {
            return inferred;
        }

        @Override
        public final Builder inferred(Boolean inferred) {
            this.inferred = inferred;
            return this;
        }

        public final void setInferred(Boolean inferred) {
            this.inferred = inferred;
        }

        @Override
        public ErrorRootCauseService build() {
            return new ErrorRootCauseService(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
