/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.xray.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetEncryptionConfigResponse extends XRayResponse implements
        ToCopyableBuilder<GetEncryptionConfigResponse.Builder, GetEncryptionConfigResponse> {
    private static final SdkField<EncryptionConfig> ENCRYPTION_CONFIG_FIELD = SdkField
            .<EncryptionConfig> builder(MarshallingType.SDK_POJO).getter(getter(GetEncryptionConfigResponse::encryptionConfig))
            .setter(setter(Builder::encryptionConfig)).constructor(EncryptionConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptionConfig").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENCRYPTION_CONFIG_FIELD));

    private final EncryptionConfig encryptionConfig;

    private GetEncryptionConfigResponse(BuilderImpl builder) {
        super(builder);
        this.encryptionConfig = builder.encryptionConfig;
    }

    /**
     * <p>
     * The encryption configuration document.
     * </p>
     * 
     * @return The encryption configuration document.
     */
    public EncryptionConfig encryptionConfig() {
        return encryptionConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(encryptionConfig());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetEncryptionConfigResponse)) {
            return false;
        }
        GetEncryptionConfigResponse other = (GetEncryptionConfigResponse) obj;
        return Objects.equals(encryptionConfig(), other.encryptionConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetEncryptionConfigResponse").add("EncryptionConfig", encryptionConfig()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EncryptionConfig":
            return Optional.ofNullable(clazz.cast(encryptionConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetEncryptionConfigResponse, T> g) {
        return obj -> g.apply((GetEncryptionConfigResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends XRayResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetEncryptionConfigResponse> {
        /**
         * <p>
         * The encryption configuration document.
         * </p>
         * 
         * @param encryptionConfig
         *        The encryption configuration document.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encryptionConfig(EncryptionConfig encryptionConfig);

        /**
         * <p>
         * The encryption configuration document.
         * </p>
         * This is a convenience that creates an instance of the {@link EncryptionConfig.Builder} avoiding the need to
         * create one manually via {@link EncryptionConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link EncryptionConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #encryptionConfig(EncryptionConfig)}.
         * 
         * @param encryptionConfig
         *        a consumer that will call methods on {@link EncryptionConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #encryptionConfig(EncryptionConfig)
         */
        default Builder encryptionConfig(Consumer<EncryptionConfig.Builder> encryptionConfig) {
            return encryptionConfig(EncryptionConfig.builder().applyMutation(encryptionConfig).build());
        }
    }

    static final class BuilderImpl extends XRayResponse.BuilderImpl implements Builder {
        private EncryptionConfig encryptionConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(GetEncryptionConfigResponse model) {
            super(model);
            encryptionConfig(model.encryptionConfig);
        }

        public final EncryptionConfig.Builder getEncryptionConfig() {
            return encryptionConfig != null ? encryptionConfig.toBuilder() : null;
        }

        @Override
        public final Builder encryptionConfig(EncryptionConfig encryptionConfig) {
            this.encryptionConfig = encryptionConfig;
            return this;
        }

        public final void setEncryptionConfig(EncryptionConfig.BuilderImpl encryptionConfig) {
            this.encryptionConfig = encryptionConfig != null ? encryptionConfig.build() : null;
        }

        @Override
        public GetEncryptionConfigResponse build() {
            return new GetEncryptionConfigResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
