/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.xray.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutEncryptionConfigRequest extends XRayRequest implements
        ToCopyableBuilder<PutEncryptionConfigRequest.Builder, PutEncryptionConfigRequest> {
    private static final SdkField<String> KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PutEncryptionConfigRequest::keyId)).setter(setter(Builder::keyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyId").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PutEncryptionConfigRequest::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_ID_FIELD, TYPE_FIELD));

    private final String keyId;

    private final String type;

    private PutEncryptionConfigRequest(BuilderImpl builder) {
        super(builder);
        this.keyId = builder.keyId;
        this.type = builder.type;
    }

    /**
     * <p>
     * An AWS KMS customer master key (CMK) in one of the following formats:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>Alias</b> - The name of the key. For example, <code>alias/MyKey</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Key ID</b> - The KMS key ID of the key. For example, <code>ae4aa6d49-a4d8-9df9-a475-4ff6d7898456</code>. AWS
     * X-Ray does not support asymmetric CMKs.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>ARN</b> - The full Amazon Resource Name of the key ID or alias. For example,
     * <code>arn:aws:kms:us-east-2:123456789012:key/ae4aa6d49-a4d8-9df9-a475-4ff6d7898456</code>. Use this format to
     * specify a key in a different account.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Omit this key if you set <code>Type</code> to <code>NONE</code>.
     * </p>
     * 
     * @return An AWS KMS customer master key (CMK) in one of the following formats:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>Alias</b> - The name of the key. For example, <code>alias/MyKey</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>Key ID</b> - The KMS key ID of the key. For example,
     *         <code>ae4aa6d49-a4d8-9df9-a475-4ff6d7898456</code>. AWS X-Ray does not support asymmetric CMKs.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>ARN</b> - The full Amazon Resource Name of the key ID or alias. For example,
     *         <code>arn:aws:kms:us-east-2:123456789012:key/ae4aa6d49-a4d8-9df9-a475-4ff6d7898456</code>. Use this
     *         format to specify a key in a different account.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Omit this key if you set <code>Type</code> to <code>NONE</code>.
     */
    public String keyId() {
        return keyId;
    }

    /**
     * <p>
     * The type of encryption. Set to <code>KMS</code> to use your own key for encryption. Set to <code>NONE</code> for
     * default encryption.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link EncryptionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of encryption. Set to <code>KMS</code> to use your own key for encryption. Set to
     *         <code>NONE</code> for default encryption.
     * @see EncryptionType
     */
    public EncryptionType type() {
        return EncryptionType.fromValue(type);
    }

    /**
     * <p>
     * The type of encryption. Set to <code>KMS</code> to use your own key for encryption. Set to <code>NONE</code> for
     * default encryption.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link EncryptionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of encryption. Set to <code>KMS</code> to use your own key for encryption. Set to
     *         <code>NONE</code> for default encryption.
     * @see EncryptionType
     */
    public String typeAsString() {
        return type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(keyId());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutEncryptionConfigRequest)) {
            return false;
        }
        PutEncryptionConfigRequest other = (PutEncryptionConfigRequest) obj;
        return Objects.equals(keyId(), other.keyId()) && Objects.equals(typeAsString(), other.typeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("PutEncryptionConfigRequest").add("KeyId", keyId()).add("Type", typeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "KeyId":
            return Optional.ofNullable(clazz.cast(keyId()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutEncryptionConfigRequest, T> g) {
        return obj -> g.apply((PutEncryptionConfigRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends XRayRequest.Builder, SdkPojo, CopyableBuilder<Builder, PutEncryptionConfigRequest> {
        /**
         * <p>
         * An AWS KMS customer master key (CMK) in one of the following formats:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>Alias</b> - The name of the key. For example, <code>alias/MyKey</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>Key ID</b> - The KMS key ID of the key. For example, <code>ae4aa6d49-a4d8-9df9-a475-4ff6d7898456</code>.
         * AWS X-Ray does not support asymmetric CMKs.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>ARN</b> - The full Amazon Resource Name of the key ID or alias. For example,
         * <code>arn:aws:kms:us-east-2:123456789012:key/ae4aa6d49-a4d8-9df9-a475-4ff6d7898456</code>. Use this format to
         * specify a key in a different account.
         * </p>
         * </li>
         * </ul>
         * <p>
         * Omit this key if you set <code>Type</code> to <code>NONE</code>.
         * </p>
         * 
         * @param keyId
         *        An AWS KMS customer master key (CMK) in one of the following formats:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>Alias</b> - The name of the key. For example, <code>alias/MyKey</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>Key ID</b> - The KMS key ID of the key. For example,
         *        <code>ae4aa6d49-a4d8-9df9-a475-4ff6d7898456</code>. AWS X-Ray does not support asymmetric CMKs.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>ARN</b> - The full Amazon Resource Name of the key ID or alias. For example,
         *        <code>arn:aws:kms:us-east-2:123456789012:key/ae4aa6d49-a4d8-9df9-a475-4ff6d7898456</code>. Use this
         *        format to specify a key in a different account.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Omit this key if you set <code>Type</code> to <code>NONE</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyId(String keyId);

        /**
         * <p>
         * The type of encryption. Set to <code>KMS</code> to use your own key for encryption. Set to <code>NONE</code>
         * for default encryption.
         * </p>
         * 
         * @param type
         *        The type of encryption. Set to <code>KMS</code> to use your own key for encryption. Set to
         *        <code>NONE</code> for default encryption.
         * @see EncryptionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EncryptionType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of encryption. Set to <code>KMS</code> to use your own key for encryption. Set to <code>NONE</code>
         * for default encryption.
         * </p>
         * 
         * @param type
         *        The type of encryption. Set to <code>KMS</code> to use your own key for encryption. Set to
         *        <code>NONE</code> for default encryption.
         * @see EncryptionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EncryptionType
         */
        Builder type(EncryptionType type);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends XRayRequest.BuilderImpl implements Builder {
        private String keyId;

        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(PutEncryptionConfigRequest model) {
            super(model);
            keyId(model.keyId);
            type(model.type);
        }

        public final String getKeyId() {
            return keyId;
        }

        @Override
        public final Builder keyId(String keyId) {
            this.keyId = keyId;
            return this;
        }

        public final void setKeyId(String keyId) {
            this.keyId = keyId;
        }

        public final String getTypeAsString() {
            return type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(EncryptionType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutEncryptionConfigRequest build() {
            return new PutEncryptionConfigRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
