/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.xray.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutTraceSegmentsResponse extends XRayResponse implements
        ToCopyableBuilder<PutTraceSegmentsResponse.Builder, PutTraceSegmentsResponse> {
    private static final SdkField<List<UnprocessedTraceSegment>> UNPROCESSED_TRACE_SEGMENTS_FIELD = SdkField
            .<List<UnprocessedTraceSegment>> builder(MarshallingType.LIST)
            .getter(getter(PutTraceSegmentsResponse::unprocessedTraceSegments))
            .setter(setter(Builder::unprocessedTraceSegments))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UnprocessedTraceSegments").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<UnprocessedTraceSegment> builder(MarshallingType.SDK_POJO)
                                            .constructor(UnprocessedTraceSegment::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(UNPROCESSED_TRACE_SEGMENTS_FIELD));

    private final List<UnprocessedTraceSegment> unprocessedTraceSegments;

    private PutTraceSegmentsResponse(BuilderImpl builder) {
        super(builder);
        this.unprocessedTraceSegments = builder.unprocessedTraceSegments;
    }

    /**
     * Returns true if the UnprocessedTraceSegments property was specified by the sender (it may be empty), or false if
     * the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasUnprocessedTraceSegments() {
        return unprocessedTraceSegments != null && !(unprocessedTraceSegments instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Segments that failed processing.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasUnprocessedTraceSegments()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Segments that failed processing.
     */
    public List<UnprocessedTraceSegment> unprocessedTraceSegments() {
        return unprocessedTraceSegments;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(unprocessedTraceSegments());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutTraceSegmentsResponse)) {
            return false;
        }
        PutTraceSegmentsResponse other = (PutTraceSegmentsResponse) obj;
        return Objects.equals(unprocessedTraceSegments(), other.unprocessedTraceSegments());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("PutTraceSegmentsResponse").add("UnprocessedTraceSegments", unprocessedTraceSegments()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "UnprocessedTraceSegments":
            return Optional.ofNullable(clazz.cast(unprocessedTraceSegments()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutTraceSegmentsResponse, T> g) {
        return obj -> g.apply((PutTraceSegmentsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends XRayResponse.Builder, SdkPojo, CopyableBuilder<Builder, PutTraceSegmentsResponse> {
        /**
         * <p>
         * Segments that failed processing.
         * </p>
         * 
         * @param unprocessedTraceSegments
         *        Segments that failed processing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unprocessedTraceSegments(Collection<UnprocessedTraceSegment> unprocessedTraceSegments);

        /**
         * <p>
         * Segments that failed processing.
         * </p>
         * 
         * @param unprocessedTraceSegments
         *        Segments that failed processing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unprocessedTraceSegments(UnprocessedTraceSegment... unprocessedTraceSegments);

        /**
         * <p>
         * Segments that failed processing.
         * </p>
         * This is a convenience that creates an instance of the {@link List<UnprocessedTraceSegment>.Builder} avoiding
         * the need to create one manually via {@link List<UnprocessedTraceSegment>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<UnprocessedTraceSegment>.Builder#build()} is called
         * immediately and its result is passed to {@link #unprocessedTraceSegments(List<UnprocessedTraceSegment>)}.
         * 
         * @param unprocessedTraceSegments
         *        a consumer that will call methods on {@link List<UnprocessedTraceSegment>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #unprocessedTraceSegments(List<UnprocessedTraceSegment>)
         */
        Builder unprocessedTraceSegments(Consumer<UnprocessedTraceSegment.Builder>... unprocessedTraceSegments);
    }

    static final class BuilderImpl extends XRayResponse.BuilderImpl implements Builder {
        private List<UnprocessedTraceSegment> unprocessedTraceSegments = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PutTraceSegmentsResponse model) {
            super(model);
            unprocessedTraceSegments(model.unprocessedTraceSegments);
        }

        public final Collection<UnprocessedTraceSegment.Builder> getUnprocessedTraceSegments() {
            return unprocessedTraceSegments != null ? unprocessedTraceSegments.stream().map(UnprocessedTraceSegment::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder unprocessedTraceSegments(Collection<UnprocessedTraceSegment> unprocessedTraceSegments) {
            this.unprocessedTraceSegments = UnprocessedTraceSegmentListCopier.copy(unprocessedTraceSegments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unprocessedTraceSegments(UnprocessedTraceSegment... unprocessedTraceSegments) {
            unprocessedTraceSegments(Arrays.asList(unprocessedTraceSegments));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unprocessedTraceSegments(Consumer<UnprocessedTraceSegment.Builder>... unprocessedTraceSegments) {
            unprocessedTraceSegments(Stream.of(unprocessedTraceSegments)
                    .map(c -> UnprocessedTraceSegment.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setUnprocessedTraceSegments(Collection<UnprocessedTraceSegment.BuilderImpl> unprocessedTraceSegments) {
            this.unprocessedTraceSegments = UnprocessedTraceSegmentListCopier.copyFromBuilder(unprocessedTraceSegments);
        }

        @Override
        public PutTraceSegmentsResponse build() {
            return new PutTraceSegmentsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
