/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.xray.model;

import static java.util.stream.Collectors.toList;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class SamplingTargetDocumentListCopier {
    static List<SamplingTargetDocument> copy(Collection<SamplingTargetDocument> samplingTargetDocumentListParam) {
        if (samplingTargetDocumentListParam == null || samplingTargetDocumentListParam instanceof SdkAutoConstructList) {
            return DefaultSdkAutoConstructList.getInstance();
        }
        List<SamplingTargetDocument> samplingTargetDocumentListParamCopy = new ArrayList<>(samplingTargetDocumentListParam);
        return Collections.unmodifiableList(samplingTargetDocumentListParamCopy);
    }

    static List<SamplingTargetDocument> copyFromBuilder(
            Collection<? extends SamplingTargetDocument.Builder> samplingTargetDocumentListParam) {
        if (samplingTargetDocumentListParam == null) {
            return null;
        }
        return copy(samplingTargetDocumentListParam.stream().map(SamplingTargetDocument.Builder::build).collect(toList()));
    }
}
