/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.dax;

import java.io.IOException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.dax.Configuration;
import software.amazon.dax.utils.CheckedFunction;

public abstract class ClientBuilder<T> {
    private final CheckedFunction<Configuration, T, IOException> ctor;
    private Configuration configuration;

    ClientBuilder(CheckedFunction<Configuration, T, IOException> ctor) {
        this.ctor = ctor;
    }

    public ClientBuilder<T> overrideConfiguration(Configuration configuration) {
        this.configuration = (Configuration)configuration.copy(c -> {});
        return this;
    }

    public T build() throws IOException {
        if (this.configuration == null) {
            throw SdkClientException.create((String)"No configuration provided");
        }
        return this.ctor.apply(this.configuration);
    }
}

