/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.dax.channel;

import io.netty.channel.Channel;
import io.netty.channel.pool.ChannelPool;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.Promise;
import software.amazon.dax.channel.ChannelAttributeKey;
import software.amazon.dax.utils.NettyUtils;

class HonorCloseOnReleaseChannelPool
implements ChannelPool {
    private final ChannelPool delegatePool;

    HonorCloseOnReleaseChannelPool(ChannelPool delegatePool) {
        this.delegatePool = delegatePool;
    }

    public Future<Channel> acquire() {
        return this.delegatePool.acquire();
    }

    public Future<Channel> acquire(Promise<Channel> promise) {
        return this.delegatePool.acquire(promise);
    }

    public Future<Void> release(Channel channel) {
        return this.release(channel, (Promise<Void>)channel.eventLoop().newPromise());
    }

    public Future<Void> release(Channel channel, Promise<Void> promise) {
        NettyUtils.doInEventLoop((EventExecutor)channel.eventLoop(), () -> {
            boolean shouldCloseOnRelease = Boolean.TRUE.equals(channel.attr(ChannelAttributeKey.CLOSE_ON_RELEASE).get());
            if (shouldCloseOnRelease && channel.isOpen() && !channel.eventLoop().isShuttingDown()) {
                channel.close();
            }
            this.delegatePool.release(channel, promise);
        });
        return promise;
    }

    public void close() {
        this.delegatePool.close();
    }
}

