/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.dax.com.amazon.dax.bits.model;

import java.io.IOException;
import software.amazon.dax.com.amazon.cbor.CborOutputStream;
import software.amazon.dax.com.amazon.dax.bits.model.Field;

public final class Fields {
    private Fields() {
    }

    public static void begin(CborOutputStream stream) throws IOException {
        stream.writeMapStreamHeader();
    }

    public static void end(CborOutputStream stream) throws IOException {
        stream.writeStreamBreak();
    }

    public static interface ModelSchema {
        public Field[] fields();
    }

    public static class EnumField<T extends EnumValue>
    extends Field {
        public EnumField(int index, String name) {
            super(index, name);
        }

        public void write(CborOutputStream stream, T v) throws IOException {
            if (v != null) {
                stream.writeInt(this.index);
                stream.writeInt(v.value());
            }
        }
    }

    public static interface EnumValue {
        public int value();
    }

    public static class StringField
    extends Field {
        public StringField(int index, String name) {
            super(index, name);
        }

        public void write(CborOutputStream stream, String value) throws IOException {
            if (value != null) {
                stream.writeInt(this.index);
                stream.writeString(value);
            }
        }
    }

    public static class IntField
    extends Field {
        public IntField(int index, String name) {
            super(index, name);
        }

        public void write(CborOutputStream stream, int value) throws IOException {
            stream.writeInt(this.index);
            stream.writeInt(value);
        }
    }

    public static class LongField
    extends Field {
        public LongField(int index, String name) {
            super(index, name);
        }

        public void write(CborOutputStream stream, long value) throws IOException {
            stream.writeInt(this.index);
            stream.writeLong(value);
        }
    }

    public static class BinaryField
    extends Field {
        public BinaryField(int index, String name) {
            super(index, name);
        }

        public void write(CborOutputStream stream, byte[] value) throws IOException {
            if (value != null) {
                stream.writeInt(this.index);
                stream.writeBytes(value);
            }
        }
    }
}

