/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.dax.dynamodb;

import io.netty.handler.codec.DecoderException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import software.amazon.awssdk.services.dynamodb.model.AttributeDefinition;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.dynamodb.model.ReturnConsumedCapacity;
import software.amazon.awssdk.services.dynamodb.model.UpdateItemRequest;
import software.amazon.awssdk.services.dynamodb.model.UpdateItemResponse;
import software.amazon.dax.channel.ResponseHandler;
import software.amazon.dax.com.amazon.cbor.CborInputStream;
import software.amazon.dax.com.amazon.cbor.NonInputStream;
import software.amazon.dax.com.amazon.dax.Constants;
import software.amazon.dax.com.amazon.dax.bits.DaxCborInputStream;
import software.amazon.dax.com.amazon.dax.bits.dynamodb.DynamoNumerals;
import software.amazon.dax.dynamodb.AttributeValueDecoder;
import software.amazon.dax.dynamodb.DaxResponseDecoder;
import software.amazon.dax.dynamodb.RefreshingCache;
import software.amazon.dax.dynamodb.SimpleCache;

public class UpdateItemResponseHandler
extends ResponseHandler<UpdateItemResponse> {
    private static final Constants.DaxResponseParam[] RESPONSE_PARAMS = Constants.DaxResponseParam.values();
    private final SimpleCache<Long, List<String>> attrListIdCache;
    private final RefreshingCache<String, List<AttributeDefinition>> keyCache;
    private final UpdateItemRequest request;

    public UpdateItemResponseHandler(CompletableFuture<UpdateItemResponse> completableFuture, RefreshingCache<String, List<AttributeDefinition>> keyCache, SimpleCache<Long, List<String>> attrListIdCache, UpdateItemRequest request) {
        super(completableFuture);
        this.keyCache = keyCache;
        this.attrListIdCache = attrListIdCache;
        this.request = request;
    }

    @Override
    public void decode(DaxCborInputStream in, CompletableFuture<UpdateItemResponse> completableFuture) throws Exception {
        UpdateItemResponse.Builder response = UpdateItemResponse.builder();
        if (this.request.returnConsumedCapacity() != null && !this.request.returnConsumedCapacity().equals((Object)ReturnConsumedCapacity.NONE)) {
            response.consumedCapacity(DaxResponseDecoder.newZeroConsumedCapacity(this.request.tableName()));
        }
        if (in.tryReadNull()) {
            completableFuture.complete((UpdateItemResponse)response.build());
            return;
        }
        this.keyCache.get(this.request.tableName()).whenComplete((keys, e) -> {
            if (e != null) {
                completableFuture.completeExceptionally((Throwable)e);
            } else {
                try {
                    this.decodeUpdateResponse(in, response, (List<AttributeDefinition>)keys, completableFuture);
                }
                catch (Exception exception) {
                    completableFuture.completeExceptionally(exception);
                }
            }
        });
    }

    private void decodeUpdateResponse(DaxCborInputStream in, UpdateItemResponse.Builder response, List<AttributeDefinition> keys, CompletableFuture<UpdateItemResponse> completableFuture) throws IOException {
        ArrayList<CompletionStage> futures = new ArrayList<CompletionStage>();
        if (in.fieldType() == 191) {
            in.consumeField();
            CborInputStream wrapper = new CborInputStream(NonInputStream.THE, 1024);
            block9: while (in.fieldType() != 255) {
                int mapKey = in.readInt();
                switch (RESPONSE_PARAMS[mapKey]) {
                    case Attributes: {
                        switch (DynamoNumerals.ReturnValue.fromName(this.request.returnValuesAsString())) {
                            case ALL_OLD: 
                            case ALL_NEW: {
                                in.beginStream();
                                wrapper.init(in);
                                futures.add(AttributeValueDecoder.decodeStreamItem(wrapper, this.attrListIdCache, null).thenApply(item -> {
                                    if (item != null) {
                                        if (keys.size() == this.request.key().size()) {
                                            item.putAll(this.request.key());
                                        } else {
                                            for (AttributeDefinition key : keys) {
                                                String keyName = key.attributeName();
                                                item.put(keyName, (AttributeValue)this.request.key().get(keyName));
                                            }
                                        }
                                        response.attributes(item);
                                    }
                                    return null;
                                }));
                                in.endStream();
                                continue block9;
                            }
                            case UPDATED_OLD: 
                            case UPDATED_NEW: {
                                futures.add(AttributeValueDecoder.decodeItemAttributeProjection(in, this.attrListIdCache, null).thenApply(attrs -> {
                                    if (!attrs.isEmpty()) {
                                        response.attributes(attrs);
                                    }
                                    return null;
                                }));
                                continue block9;
                            }
                        }
                        in.skipObject();
                        continue block9;
                    }
                    case ConsumedCapacity: {
                        response.consumedCapacity(DaxResponseDecoder.decodeConsumedCapacity(in));
                        continue block9;
                    }
                    case ItemCollectionMetrics: {
                        response.itemCollectionMetrics(DaxResponseDecoder.decodeItemCollectionMetrics(in, keys));
                        continue block9;
                    }
                }
                throw new DecoderException("Unknown value type: " + mapKey);
            }
            in.consumeField();
        }
        CompletableFuture.allOf(futures.toArray(new CompletableFuture[futures.size()])).whenComplete((placeholder, e) -> {
            if (e != null) {
                completableFuture.completeExceptionally((Throwable)e);
            } else {
                completableFuture.complete((UpdateItemResponse)response.build());
            }
        });
    }
}

