/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.dax.utils;

import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import software.amazon.dax.enums.IpDiscovery;

public final class IpFilter {
    private static final IpFilter INSTANCE = new IpFilter();

    private IpFilter() {
    }

    public static IpFilter getInstance() {
        return INSTANCE;
    }

    public List<InetAddress> filterAndSelectInetAddress(InetAddress[] allAddrs, IpDiscovery ipDiscovery) {
        List ipv4List = Arrays.stream(allAddrs).filter(addr -> addr instanceof Inet4Address).collect(Collectors.toList());
        List ipv6List = Arrays.stream(allAddrs).filter(addr -> addr instanceof Inet6Address).collect(Collectors.toList());
        return this.selectAddressType(ipv4List, ipv6List, ipDiscovery);
    }

    public List<InetSocketAddress> filterAndSelectInetSocketAddress(Set<InetSocketAddress> allAddrs, IpDiscovery ipDiscovery) {
        List ipv4List = allAddrs.stream().filter(addr -> addr.getAddress() instanceof Inet4Address).collect(Collectors.toList());
        List ipv6List = allAddrs.stream().filter(addr -> addr.getAddress() instanceof Inet6Address).collect(Collectors.toList());
        return this.selectAddressType(ipv4List, ipv6List, ipDiscovery);
    }

    private <T> List<T> selectAddressType(List<T> ipv4List, List<T> ipv6List, IpDiscovery ipDiscovery) {
        boolean hasIPv6;
        boolean hasIPv4 = !ipv4List.isEmpty();
        boolean bl = hasIPv6 = !ipv6List.isEmpty();
        if (ipDiscovery == null) {
            return hasIPv4 ? ipv4List : ipv6List;
        }
        if (ipDiscovery.equals((Object)IpDiscovery.IPV6)) {
            if (!hasIPv6) {
                throw new IllegalArgumentException("ipDiscovery does not match the SupportedNetworkType. ipDiscovery: " + (Object)((Object)ipDiscovery) + ", SupportedNetworkType: " + (Object)((Object)IpDiscovery.IPV4) + ".");
            }
            return ipv6List;
        }
        if (!hasIPv4) {
            throw new IllegalArgumentException("ipDiscovery does not match the SupportedNetworkType. ipDiscovery: " + (Object)((Object)ipDiscovery) + ", SupportedNetworkType: " + (Object)((Object)IpDiscovery.IPV6) + ".");
        }
        return ipv4List;
    }
}

