/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jsii;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import org.jetbrains.annotations.Nullable;
import software.amazon.jsii.JsiiClient;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObjectMapper;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiPromise;
import software.amazon.jsii.NativeType;

public final class Kernel {
    @Nullable
    public static <T> T asyncCall(Object receiver, String method, NativeType<T> nativeType, Object ... args) {
        JsiiEngine engine = JsiiEngine.getEngineFor(receiver);
        JsiiObjectRef objRef = engine.nativeToObjRef(receiver);
        JsiiClient client = engine.getClient();
        JsiiPromise promise = client.beginAsyncMethod(objRef, method, (ArrayNode)JsiiObjectMapper.valueToTree(args));
        engine.processAllPendingCallbacks();
        return JsiiObjectMapper.treeToValue(client.endAsyncMethod(promise), nativeType);
    }

    @Nullable
    public static <T> T call(Object receiver, String method, NativeType<T> nativeType, Object ... args) {
        JsiiEngine engine = JsiiEngine.getEngineFor(receiver);
        JsiiObjectRef objRef = engine.nativeToObjRef(receiver);
        JsonNode result = engine.getClient().callMethod(objRef, method, (ArrayNode)JsiiObjectMapper.valueToTree(args));
        return JsiiObjectMapper.treeToValue(result, nativeType);
    }

    @Nullable
    public static <T> T get(Object receiver, String property, NativeType<T> type) {
        JsiiEngine engine = JsiiEngine.getEngineFor(receiver);
        JsiiObjectRef objRef = engine.nativeToObjRef(receiver);
        JsonNode result = engine.getClient().getPropertyValue(objRef, property);
        return JsiiObjectMapper.treeToValue(result, type);
    }

    public static void set(Object receiver, String property, @Nullable Object value) {
        JsiiEngine engine = JsiiEngine.getEngineFor(receiver);
        JsiiObjectRef objRef = engine.nativeToObjRef(receiver);
        engine.getClient().setPropertyValue(objRef, property, (JsonNode)JsiiObjectMapper.valueToTree(value));
    }

    private Kernel() {
        throw new UnsupportedOperationException();
    }
}

