/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.lambda.powertools.logging.logback;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.LoggingEvent;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.AppenderBase;
import ch.qos.logback.core.spi.AppenderAttachable;
import ch.qos.logback.core.spi.AppenderAttachableImpl;
import java.util.Deque;
import java.util.Iterator;
import org.slf4j.LoggerFactory;
import software.amazon.lambda.powertools.common.internal.LambdaHandlerProcessor;
import software.amazon.lambda.powertools.logging.internal.BufferManager;
import software.amazon.lambda.powertools.logging.internal.KeyBuffer;

public class BufferingAppender
extends AppenderBase<ILoggingEvent>
implements AppenderAttachable<ILoggingEvent>,
BufferManager {
    private static final int DEFAULT_BUFFER_SIZE = 20480;
    private final AppenderAttachableImpl<ILoggingEvent> aai = new AppenderAttachableImpl();
    private Level bufferAtVerbosity = Level.DEBUG;
    private boolean flushOnErrorLog = true;
    private int maxBytes = 20480;
    private KeyBuffer<String, ILoggingEvent> buffer;

    public void start() {
        if (this.buffer == null) {
            this.buffer = new KeyBuffer(this.maxBytes, event -> event.getFormattedMessage().length(), this::logOverflowWarning);
        }
        super.start();
    }

    protected void append(ILoggingEvent event) {
        LambdaHandlerProcessor.getXrayTraceId().ifPresentOrElse(traceId -> {
            if (this.shouldBuffer(event.getLevel())) {
                this.buffer.add(traceId, (Object)event);
            } else {
                this.aai.appendLoopOnAppenders((Object)event);
            }
            if (this.flushOnErrorLog && event.getLevel().isGreaterOrEqual(Level.ERROR)) {
                this.flushBuffer((String)traceId);
            }
        }, () -> {
            int n = this.aai.appendLoopOnAppenders((Object)event);
        });
    }

    private boolean shouldBuffer(Level level) {
        return level.levelInt <= this.bufferAtVerbosity.levelInt;
    }

    public void clearBuffer() {
        LambdaHandlerProcessor.getXrayTraceId().ifPresent(arg_0 -> this.buffer.clear(arg_0));
    }

    public void flushBuffer() {
        LambdaHandlerProcessor.getXrayTraceId().ifPresent(this::flushBuffer);
    }

    private void flushBuffer(String traceId) {
        Deque events = this.buffer.removeAll((Object)traceId);
        if (events != null) {
            events.forEach(arg_0 -> this.aai.appendLoopOnAppenders(arg_0));
        }
    }

    public void setBufferAtVerbosity(String level) {
        this.bufferAtVerbosity = Level.toLevel((String)level, (Level)Level.DEBUG);
    }

    public void setMaxBytes(int maxBytes) {
        this.maxBytes = maxBytes;
    }

    public void setFlushOnErrorLog(boolean flushOnErrorLog) {
        this.flushOnErrorLog = flushOnErrorLog;
    }

    public void addAppender(Appender<ILoggingEvent> newAppender) {
        this.aai.addAppender(newAppender);
    }

    public Iterator<Appender<ILoggingEvent>> iteratorForAppenders() {
        return this.aai.iteratorForAppenders();
    }

    public Appender<ILoggingEvent> getAppender(String name) {
        return this.aai.getAppender(name);
    }

    public boolean isAttached(Appender<ILoggingEvent> appender) {
        return this.aai.isAttached(appender);
    }

    public void detachAndStopAllAppenders() {
        this.aai.detachAndStopAllAppenders();
    }

    public boolean detachAppender(Appender<ILoggingEvent> appender) {
        return this.aai.detachAppender(appender);
    }

    public boolean detachAppender(String name) {
        return this.aai.detachAppender(name);
    }

    private void logOverflowWarning() {
        Logger logbackLogger = (Logger)LoggerFactory.getLogger(BufferingAppender.class);
        LoggingEvent warningEvent = new LoggingEvent(BufferingAppender.class.getName(), logbackLogger, Level.WARN, "Some logs are not displayed because they were evicted from the buffer. Increase buffer size to store more logs in the buffer.", null, null);
        warningEvent.setTimeStamp(System.currentTimeMillis());
        this.aai.appendLoopOnAppenders((Object)warningEvent);
    }
}

