/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.lambda.powertools.logging.logback.internal;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.LoggerContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.ILoggerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.lambda.powertools.logging.internal.BufferManager;
import software.amazon.lambda.powertools.logging.internal.LoggingManager;
import software.amazon.lambda.powertools.logging.logback.BufferingAppender;

public class LogbackLoggingManager
implements LoggingManager,
BufferManager {
    private final LoggerContext loggerContext;

    public LogbackLoggingManager() {
        ILoggerFactory loggerFactory = LoggerFactory.getILoggerFactory();
        if (!(loggerFactory instanceof LoggerContext)) {
            throw new RuntimeException("LoggerFactory does not match required type: " + LoggerContext.class.getName());
        }
        this.loggerContext = (LoggerContext)loggerFactory;
    }

    public void setLogLevel(org.slf4j.event.Level logLevel) {
        List loggers = this.loggerContext.getLoggerList();
        for (ch.qos.logback.classic.Logger logger : loggers) {
            logger.setLevel(Level.convertAnSLF4JLevel((org.slf4j.event.Level)logLevel));
        }
    }

    public org.slf4j.event.Level getLogLevel(Logger logger) {
        return org.slf4j.event.Level.valueOf((String)this.loggerContext.getLogger(logger.getName()).getEffectiveLevel().toString());
    }

    public void flushBuffer() {
        this.getBufferingAppenders().forEach(BufferingAppender::flushBuffer);
    }

    public void clearBuffer() {
        this.getBufferingAppenders().forEach(BufferingAppender::clearBuffer);
    }

    private Collection<BufferingAppender> getBufferingAppenders() {
        return this.loggerContext.getLoggerList().stream().flatMap(logger -> {
            Iterator iterator = logger.iteratorForAppenders();
            ArrayList appenders = new ArrayList();
            iterator.forEachRemaining(appenders::add);
            return appenders.stream();
        }).filter(BufferingAppender.class::isInstance).map(BufferingAppender.class::cast).collect(Collectors.toList());
    }
}

