/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.mockserver.client;

import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

class MockServerClientEventBus {
    private final Map<EventType, Set<SubscriberHandler>> subscribers = new LinkedHashMap<EventType, Set<SubscriberHandler>>();

    MockServerClientEventBus() {
    }

    void publish(EventType event) {
        for (SubscriberHandler subscriber : this.subscribers.get((Object)event)) {
            subscriber.handle();
        }
    }

    public void subscribe(SubscriberHandler subscriber, EventType ... events) {
        for (EventType event : events) {
            this.subscribers.computeIfAbsent(event, x -> new LinkedHashSet()).add(subscriber);
        }
    }

    static interface SubscriberHandler {
        public void handle();
    }

    static enum EventType {
        STOP,
        RESET;

    }
}

