/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.mockserver.httpclient;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpContentDecompressor;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.proxy.Socks5ProxyHandler;
import java.net.SocketAddress;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.xdev.mockserver.codec.MockServerBinaryClientCodec;
import software.xdev.mockserver.codec.MockServerHttpClientCodec;
import software.xdev.mockserver.httpclient.HttpClientConnectionErrorHandler;
import software.xdev.mockserver.httpclient.HttpClientHandler;
import software.xdev.mockserver.logging.LoggingHandler;
import software.xdev.mockserver.model.Protocol;
import software.xdev.mockserver.proxyconfiguration.ProxyConfiguration;
import software.xdev.mockserver.util.StringUtils;

@ChannelHandler.Sharable
public class HttpClientInitializer
extends ChannelInitializer<SocketChannel> {
    private static final Logger LOG = LoggerFactory.getLogger(HttpClientInitializer.class);
    private final Protocol httpProtocol;
    private final HttpClientConnectionErrorHandler httpClientConnectionHandler;
    private final CompletableFuture<Protocol> protocolFuture;
    private final HttpClientHandler httpClientHandler;
    private final Map<ProxyConfiguration.Type, ProxyConfiguration> proxyConfigurations;

    HttpClientInitializer(Map<ProxyConfiguration.Type, ProxyConfiguration> proxyConfigurations, Protocol httpProtocol) {
        this.proxyConfigurations = proxyConfigurations;
        this.httpProtocol = httpProtocol;
        this.protocolFuture = new CompletableFuture();
        this.httpClientHandler = new HttpClientHandler();
        this.httpClientConnectionHandler = new HttpClientConnectionErrorHandler();
    }

    public void whenComplete(BiConsumer<? super Protocol, ? super Throwable> action) {
        this.protocolFuture.whenComplete(action);
    }

    public void initChannel(SocketChannel channel) {
        ChannelPipeline pipeline = channel.pipeline();
        if (this.proxyConfigurations != null && this.proxyConfigurations.containsKey((Object)ProxyConfiguration.Type.SOCKS5)) {
            ProxyConfiguration proxyConfiguration = this.proxyConfigurations.get((Object)ProxyConfiguration.Type.SOCKS5);
            if (StringUtils.isNotBlank(proxyConfiguration.getUsername()) && StringUtils.isNotBlank(proxyConfiguration.getPassword())) {
                pipeline.addLast(new ChannelHandler[]{new Socks5ProxyHandler((SocketAddress)proxyConfiguration.getProxyAddress(), proxyConfiguration.getUsername(), proxyConfiguration.getPassword())});
            } else {
                pipeline.addLast(new ChannelHandler[]{new Socks5ProxyHandler((SocketAddress)proxyConfiguration.getProxyAddress())});
            }
        }
        pipeline.addLast(new ChannelHandler[]{this.httpClientConnectionHandler});
        if (LOG.isTraceEnabled()) {
            pipeline.addLast(new ChannelHandler[]{new LoggingHandler(HttpClientHandler.class.getName())});
        }
        if (this.httpProtocol == null) {
            this.configureBinaryPipeline(pipeline);
        } else {
            this.configureHttp1Pipeline(pipeline);
        }
    }

    private void configureHttp1Pipeline(ChannelPipeline pipeline) {
        pipeline.addLast(new ChannelHandler[]{new HttpClientCodec()});
        pipeline.addLast(new ChannelHandler[]{new HttpContentDecompressor()});
        pipeline.addLast(new ChannelHandler[]{new HttpObjectAggregator(Integer.MAX_VALUE)});
        pipeline.addLast(new ChannelHandler[]{new MockServerHttpClientCodec(this.proxyConfigurations)});
        pipeline.addLast(new ChannelHandler[]{this.httpClientHandler});
        this.protocolFuture.complete(Protocol.HTTP_1_1);
    }

    private void configureBinaryPipeline(ChannelPipeline pipeline) {
        pipeline.addLast(new ChannelHandler[]{new MockServerBinaryClientCodec()});
        pipeline.addLast(new ChannelHandler[]{this.httpClientHandler});
        this.protocolFuture.complete(null);
    }
}

