/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.mockserver.mappers;

import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.cookie.ClientCookieDecoder;
import io.netty.handler.codec.http.cookie.Cookie;
import io.netty.handler.codec.http.cookie.ServerCookieDecoder;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.xdev.mockserver.codec.BodyDecoderEncoder;
import software.xdev.mockserver.model.Cookies;
import software.xdev.mockserver.model.Header;
import software.xdev.mockserver.model.Headers;
import software.xdev.mockserver.model.HttpResponse;
import software.xdev.mockserver.model.NottableString;

public class FullHttpResponseToMockServerHttpResponse {
    private static final Logger LOG = LoggerFactory.getLogger(FullHttpResponseToMockServerHttpResponse.class);
    private final BodyDecoderEncoder bodyDecoderEncoder = new BodyDecoderEncoder();

    public HttpResponse mapFullHttpResponseToMockServerResponse(FullHttpResponse fullHttpResponse) {
        HttpResponse httpResponse = new HttpResponse();
        try {
            if (fullHttpResponse != null) {
                if (fullHttpResponse.decoderResult().isFailure()) {
                    LOG.error("Exception decoding response {}", (Object)fullHttpResponse.decoderResult().cause().getMessage());
                }
                this.setStatusCode(httpResponse, fullHttpResponse);
                this.setHeaders(httpResponse, fullHttpResponse);
                this.setCookies(httpResponse);
                this.setBody(httpResponse, fullHttpResponse);
            }
        }
        catch (Exception ex) {
            LOG.error("Exception decoding response", (Throwable)ex);
        }
        return httpResponse;
    }

    private void setStatusCode(HttpResponse httpResponse, FullHttpResponse fullHttpResponse) {
        HttpResponseStatus status = fullHttpResponse.status();
        httpResponse.withStatusCode(status.code());
        httpResponse.withReasonPhrase(status.reasonPhrase());
    }

    private void setHeaders(HttpResponse httpResponse, FullHttpResponse fullHttpResponse) {
        Set headerNames = fullHttpResponse.headers().names();
        if (!headerNames.isEmpty()) {
            Headers headers = new Headers(new Header[0]);
            for (String headerName : headerNames) {
                headers.withEntry(headerName, fullHttpResponse.headers().getAll(headerName));
            }
            httpResponse.withHeaders(headers);
        }
    }

    private void setCookies(HttpResponse httpResponse) {
        Cookies cookies = new Cookies(new software.xdev.mockserver.model.Cookie[0]);
        for (Header header : httpResponse.getHeaderList()) {
            if (header.getName().getValue().equalsIgnoreCase("Set-Cookie")) {
                for (NottableString cookieHeader : header.getValues()) {
                    Cookie httpCookie = ClientCookieDecoder.LAX.decode(cookieHeader.getValue());
                    String name = httpCookie.name().trim();
                    String value = httpCookie.value() != null ? httpCookie.value().trim() : "";
                    cookies.withEntry(new software.xdev.mockserver.model.Cookie(name, value));
                }
            }
            if (!header.getName().getValue().equalsIgnoreCase("Cookie")) continue;
            for (NottableString cookieHeader : header.getValues()) {
                for (Cookie httpCookie : ServerCookieDecoder.LAX.decode(cookieHeader.getValue())) {
                    String name = httpCookie.name().trim();
                    String value = httpCookie.value() != null ? httpCookie.value().trim() : "";
                    cookies.withEntry(new software.xdev.mockserver.model.Cookie(name, value));
                }
            }
        }
        if (!cookies.isEmpty()) {
            httpResponse.withCookies(cookies);
        }
    }

    private void setBody(HttpResponse httpResponse, FullHttpResponse fullHttpResponse) {
        httpResponse.withBody(this.bodyDecoderEncoder.byteBufToBody(fullHttpResponse.content(), fullHttpResponse.headers().get((CharSequence)HttpHeaderNames.CONTENT_TYPE)));
    }
}

