/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.mockserver.serialization;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.BiFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.xdev.mockserver.mock.Expectation;
import software.xdev.mockserver.serialization.JacksonUtils;
import software.xdev.mockserver.serialization.JsonArraySerializer;
import software.xdev.mockserver.serialization.ObjectMapperFactory;
import software.xdev.mockserver.serialization.Serializer;
import software.xdev.mockserver.serialization.model.ExpectationDTO;
import software.xdev.mockserver.util.StringUtils;

public class ExpectationSerializer
implements Serializer<Expectation> {
    private static final Logger LOG = LoggerFactory.getLogger(ExpectationSerializer.class);
    private final ObjectWriter objectWriter;
    private final ObjectMapper objectMapper;
    private final JsonArraySerializer jsonArraySerializer = new JsonArraySerializer();

    public ExpectationSerializer() {
        this(false);
    }

    public ExpectationSerializer(boolean serialiseDefaultValues) {
        this.objectWriter = ObjectMapperFactory.createObjectMapper(true, serialiseDefaultValues, new JsonSerializer[0]);
        this.objectMapper = ObjectMapperFactory.createObjectMapper();
    }

    @Override
    public String serialize(Expectation expectation) {
        if (expectation == null) {
            return "";
        }
        try {
            return this.objectWriter.writeValueAsString((Object)new ExpectationDTO(expectation));
        }
        catch (Exception e) {
            throw new IllegalStateException("Exception while serializing expectation to JSON with value " + String.valueOf(expectation), e);
        }
    }

    @Override
    public String serialize(List<Expectation> expectations) {
        return this.serialize(expectations.toArray(new Expectation[0]));
    }

    @Override
    public String serialize(Expectation ... expectations) {
        try {
            if (expectations == null || expectations.length == 0) {
                return "[]";
            }
            ExpectationDTO[] expectationDTOs = new ExpectationDTO[expectations.length];
            for (int i = 0; i < expectations.length; ++i) {
                expectationDTOs[i] = new ExpectationDTO(expectations[i]);
            }
            return this.objectWriter.writeValueAsString((Object)expectationDTOs);
        }
        catch (Exception e) {
            throw new IllegalStateException("Exception while serializing expectation to JSON with value " + String.valueOf(Arrays.asList(expectations)), e);
        }
    }

    @Override
    public Expectation deserialize(String jsonExpectation) {
        try {
            ExpectationDTO expectationDTO = (ExpectationDTO)this.objectMapper.readValue(jsonExpectation, ExpectationDTO.class);
            if (expectationDTO != null) {
                return expectationDTO.buildObject();
            }
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("exception while parsing [" + jsonExpectation + "] for Expectation", ex);
        }
        return null;
    }

    @Override
    public Class<Expectation> supportsType() {
        return Expectation.class;
    }

    public Expectation[] deserializeArray(String jsonExpectations, boolean allowEmpty) {
        return this.deserializeArray(jsonExpectations, allowEmpty, (s, expectation) -> expectation);
    }

    public Expectation[] deserializeArray(String jsonExpectations, boolean allowEmpty, BiFunction<String, List<Expectation>, List<Expectation>> expectationModifier) {
        if (StringUtils.isBlank(jsonExpectations)) {
            throw new IllegalArgumentException("1 error:\n - an expectation or expectation array is required but value was \"" + jsonExpectations + "\"");
        }
        ArrayList expectations = new ArrayList();
        ArrayList<String> validationErrorsList = new ArrayList<String>();
        List<JsonNode> jsonExpectationList = this.jsonArraySerializer.splitJSONArrayToJSONNodes(jsonExpectations);
        if (!jsonExpectationList.isEmpty()) {
            for (int i = 0; i < jsonExpectationList.size(); ++i) {
                String jsonExpectation = JacksonUtils.prettyPrint(jsonExpectationList.get(i));
                if (jsonExpectationList.size() > 100) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Processing JSON expectation {} of {}: {}", new Object[]{i + 1, jsonExpectationList.size(), jsonExpectation});
                    } else if (LOG.isInfoEnabled()) {
                        LOG.info("Processing JSON expectation {} of {}", (Object)(i + 1), (Object)jsonExpectationList.size());
                    }
                }
                try {
                    expectations.addAll(expectationModifier.apply(jsonExpectation, Collections.singletonList(this.deserialize(jsonExpectation))));
                    continue;
                }
                catch (IllegalArgumentException iae) {
                    validationErrorsList.add(iae.getMessage());
                }
            }
            if (!validationErrorsList.isEmpty()) {
                if (validationErrorsList.size() > 1) {
                    throw new IllegalArgumentException(("[\n" + String.join((CharSequence)",\n\n", validationErrorsList)).replaceAll("\n", "\n  ") + "\n]");
                }
                throw new IllegalArgumentException((String)validationErrorsList.get(0));
            }
        } else if (!allowEmpty) {
            throw new IllegalArgumentException("1 error:\n - an expectation or array of expectations is required");
        }
        return expectations.toArray(new Expectation[0]);
    }
}

