/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.mockserver.serialization;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.json.JsonReadFeature;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import software.xdev.mockserver.serialization.ObjectMapperFactoryCustomizer;
import software.xdev.mockserver.serialization.deserializers.body.BodyDTODeserializer;
import software.xdev.mockserver.serialization.deserializers.body.BodyWithContentTypeDTODeserializer;
import software.xdev.mockserver.serialization.deserializers.collections.CookiesDeserializer;
import software.xdev.mockserver.serialization.deserializers.collections.HeadersDeserializer;
import software.xdev.mockserver.serialization.deserializers.collections.ParametersDeserializer;
import software.xdev.mockserver.serialization.deserializers.condition.TimeToLiveDTODeserializer;
import software.xdev.mockserver.serialization.deserializers.condition.VerificationTimesDTODeserializer;
import software.xdev.mockserver.serialization.deserializers.request.RequestDefinitionDTODeserializer;
import software.xdev.mockserver.serialization.deserializers.string.NottableStringDeserializer;
import software.xdev.mockserver.serialization.serializers.body.BinaryBodyDTOSerializer;
import software.xdev.mockserver.serialization.serializers.body.BinaryBodySerializer;
import software.xdev.mockserver.serialization.serializers.body.ParameterBodyDTOSerializer;
import software.xdev.mockserver.serialization.serializers.body.ParameterBodySerializer;
import software.xdev.mockserver.serialization.serializers.body.RegexBodyDTOSerializer;
import software.xdev.mockserver.serialization.serializers.body.RegexBodySerializer;
import software.xdev.mockserver.serialization.serializers.body.StringBodyDTOSerializer;
import software.xdev.mockserver.serialization.serializers.body.StringBodySerializer;
import software.xdev.mockserver.serialization.serializers.collections.CookiesSerializer;
import software.xdev.mockserver.serialization.serializers.collections.HeadersSerializer;
import software.xdev.mockserver.serialization.serializers.collections.ParametersSerializer;
import software.xdev.mockserver.serialization.serializers.condition.VerificationTimesDTOSerializer;
import software.xdev.mockserver.serialization.serializers.condition.VerificationTimesSerializer;
import software.xdev.mockserver.serialization.serializers.request.HttpRequestDTOSerializer;
import software.xdev.mockserver.serialization.serializers.request.HttpRequestSerializer;
import software.xdev.mockserver.serialization.serializers.response.HttpResponseDTOSerializer;
import software.xdev.mockserver.serialization.serializers.response.HttpResponseSerializer;
import software.xdev.mockserver.serialization.serializers.response.TimeToLiveDTOSerializer;
import software.xdev.mockserver.serialization.serializers.response.TimeToLiveSerializer;
import software.xdev.mockserver.serialization.serializers.response.TimesDTOSerializer;
import software.xdev.mockserver.serialization.serializers.response.TimesSerializer;
import software.xdev.mockserver.serialization.serializers.string.NottableStringSerializer;

public final class ObjectMapperFactory {
    private static ObjectMapper objectMapper = ObjectMapperFactory.buildObjectMapperWithDeserializerAndSerializers(Collections.emptyList(), Collections.emptyList(), false);
    private static final ObjectWriter PRETTY_PRINT_WRITER = ObjectMapperFactory.buildObjectMapperWithDeserializerAndSerializers(Collections.emptyList(), Collections.emptyList(), false).writerWithDefaultPrettyPrinter();
    private static final ObjectWriter PRETTY_PRINT_WRITER_THAT_SERIALISES_DEFAULT_FIELDS = ObjectMapperFactory.buildObjectMapperWithDeserializerAndSerializers(Collections.emptyList(), Collections.emptyList(), true).writerWithDefaultPrettyPrinter();
    private static final ObjectWriter WRITER = ObjectMapperFactory.buildObjectMapperWithDeserializerAndSerializers(Collections.emptyList(), Collections.emptyList(), false).writer();
    private static List<ObjectMapperFactoryCustomizer> customizers;

    public static ObjectMapper createObjectMapper() {
        if (objectMapper == null) {
            objectMapper = ObjectMapperFactory.buildObjectMapperWithDeserializerAndSerializers(Collections.emptyList(), Collections.emptyList(), false);
        }
        return objectMapper;
    }

    public static ObjectMapper createObjectMapper(JsonDeserializer ... replacementJsonDeserializers) {
        if (replacementJsonDeserializers == null || replacementJsonDeserializers.length == 0) {
            if (objectMapper == null) {
                objectMapper = ObjectMapperFactory.buildObjectMapperWithDeserializerAndSerializers(Collections.emptyList(), Collections.emptyList(), false);
            }
            return objectMapper;
        }
        return ObjectMapperFactory.buildObjectMapperWithDeserializerAndSerializers(Arrays.asList(replacementJsonDeserializers), Collections.emptyList(), false);
    }

    public static ObjectWriter createObjectMapper(boolean pretty, boolean serialiseDefaultValues, JsonSerializer ... additionJsonSerializers) {
        if (additionJsonSerializers == null || additionJsonSerializers.length == 0) {
            if (pretty && serialiseDefaultValues) {
                return PRETTY_PRINT_WRITER_THAT_SERIALISES_DEFAULT_FIELDS;
            }
            if (pretty) {
                return PRETTY_PRINT_WRITER;
            }
            return WRITER;
        }
        if (pretty) {
            return ObjectMapperFactory.buildObjectMapperWithDeserializerAndSerializers(Collections.emptyList(), Arrays.asList(additionJsonSerializers), serialiseDefaultValues).writerWithDefaultPrettyPrinter();
        }
        return ObjectMapperFactory.buildObjectMapperWithDeserializerAndSerializers(Collections.emptyList(), Arrays.asList(additionJsonSerializers), serialiseDefaultValues).writer();
    }

    public static ObjectMapper buildObjectMapperWithoutRemovingEmptyValues() {
        return new ObjectMapper(JsonFactory.builder().configure(JsonReadFeature.ALLOW_UNESCAPED_CONTROL_CHARS, true).configure(JsonReadFeature.ALLOW_BACKSLASH_ESCAPING_ANY_CHARACTER, true).configure(JsonReadFeature.ALLOW_LEADING_ZEROS_FOR_NUMBERS, true).configure(JsonReadFeature.ALLOW_NON_NUMERIC_NUMBERS, true).configure(JsonReadFeature.ALLOW_MISSING_VALUES, true).configure(JsonReadFeature.ALLOW_TRAILING_COMMA, true).build()).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).configure(DeserializationFeature.FAIL_ON_NULL_FOR_PRIMITIVES, false).configure(DeserializationFeature.FAIL_ON_NUMBERS_FOR_ENUMS, false).configure(DeserializationFeature.FAIL_ON_TRAILING_TOKENS, false).configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false).configure(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY, true).configure(DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT, true).configure(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL, true).configure(JsonParser.Feature.ALLOW_COMMENTS, true).configure(JsonParser.Feature.ALLOW_YAML_COMMENTS, true).configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, true).configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true).configure(JsonParser.Feature.IGNORE_UNDEFINED, true).configure(DeserializationFeature.USE_JAVA_ARRAY_FOR_JSON_ARRAY, true).configure(MapperFeature.SORT_PROPERTIES_ALPHABETICALLY, true);
    }

    public static ObjectMapper buildObjectMapperWithOnlyConfigurationDefaults() {
        return ObjectMapperFactory.buildObjectMapperWithoutRemovingEmptyValues().setSerializationInclusion(JsonInclude.Include.NON_DEFAULT).setSerializationInclusion(JsonInclude.Include.NON_NULL).setSerializationInclusion(JsonInclude.Include.NON_EMPTY).registerModule((Module)new JavaTimeModule());
    }

    private static ObjectMapper buildObjectMapperWithDeserializerAndSerializers(List<JsonDeserializer> replacementJsonDeserializers, List<JsonSerializer> replacementJsonSerializers, boolean serialiseDefaultValues) {
        ObjectMapper objectMapper = ObjectMapperFactory.buildObjectMapperWithOnlyConfigurationDefaults();
        SimpleModule module = new SimpleModule();
        ObjectMapperFactory.addDeserializers(module, replacementJsonDeserializers.toArray(new JsonDeserializer[0]));
        ObjectMapperFactory.addSerializers(module, replacementJsonSerializers.toArray(new JsonSerializer[0]), serialiseDefaultValues);
        objectMapper.registerModule((Module)module);
        return objectMapper;
    }

    private static void addDeserializers(SimpleModule module, JsonDeserializer[] replacementJsonDeserializers) {
        List<JsonDeserializer> jsonDeserializers = Arrays.asList(new JsonDeserializer[]{new RequestDefinitionDTODeserializer(), new TimeToLiveDTODeserializer(), new BodyDTODeserializer(), new BodyWithContentTypeDTODeserializer(), new VerificationTimesDTODeserializer(), new NottableStringDeserializer(), new HeadersDeserializer(), new ParametersDeserializer(), new CookiesDeserializer()});
        HashMap<Class, JsonDeserializer> jsonDeserializersByType = new HashMap<Class, JsonDeserializer>();
        for (JsonDeserializer jsonDeserializer : jsonDeserializers) {
            jsonDeserializersByType.put(jsonDeserializer.handledType(), jsonDeserializer);
        }
        for (JsonDeserializer additionJsonDeserializer : replacementJsonDeserializers) {
            jsonDeserializersByType.put(additionJsonDeserializer.handledType(), additionJsonDeserializer);
        }
        for (Map.Entry entry : jsonDeserializersByType.entrySet()) {
            module.addDeserializer((Class)entry.getKey(), (JsonDeserializer)entry.getValue());
        }
    }

    private static void addSerializers(SimpleModule module, JsonSerializer[] replacementJsonSerializers, boolean serialiseDefaultValues) {
        ArrayList<StdSerializer> jsonSerializers = new ArrayList<StdSerializer>(List.of(new StdSerializer[]{new TimesSerializer(), new TimesDTOSerializer(), new TimeToLiveSerializer(), new TimeToLiveDTOSerializer(), new HttpRequestSerializer(), new HttpRequestDTOSerializer(), new BinaryBodySerializer(), new BinaryBodyDTOSerializer(), new ParameterBodySerializer(), new ParameterBodyDTOSerializer(), new RegexBodySerializer(), new RegexBodyDTOSerializer(), new StringBodySerializer(serialiseDefaultValues), new StringBodyDTOSerializer(serialiseDefaultValues), new VerificationTimesDTOSerializer(), new VerificationTimesSerializer(), new NottableStringSerializer(), new HttpResponseSerializer(), new HttpResponseDTOSerializer(), new HeadersSerializer(), new ParametersSerializer(), new CookiesSerializer()}));
        ObjectMapperFactory.customizers().stream().flatMap(c -> c.additionalSerializers().stream()).forEach(jsonSerializers::add);
        HashMap<Class, JsonSerializer> jsonSerializersByType = new HashMap<Class, JsonSerializer>();
        for (JsonSerializer jsonSerializer : jsonSerializers) {
            jsonSerializersByType.put(jsonSerializer.handledType(), jsonSerializer);
        }
        for (JsonSerializer additionJsonSerializer : replacementJsonSerializers) {
            jsonSerializersByType.put(additionJsonSerializer.handledType(), additionJsonSerializer);
        }
        for (Map.Entry entry : jsonSerializersByType.entrySet()) {
            module.addSerializer((Class)entry.getKey(), (JsonSerializer)entry.getValue());
        }
    }

    private static List<ObjectMapperFactoryCustomizer> customizers() {
        if (customizers == null) {
            customizers = ServiceLoader.load(ObjectMapperFactoryCustomizer.class).stream().map(ServiceLoader.Provider::get).toList();
        }
        return customizers;
    }

    private ObjectMapperFactory() {
    }
}

