/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.mockserver.serialization.model;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Base64;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.xdev.mockserver.model.BinaryBody;
import software.xdev.mockserver.model.Body;
import software.xdev.mockserver.model.ParameterBody;
import software.xdev.mockserver.model.RegexBody;
import software.xdev.mockserver.model.StringBody;
import software.xdev.mockserver.serialization.ObjectMapperFactory;
import software.xdev.mockserver.serialization.model.BinaryBodyDTO;
import software.xdev.mockserver.serialization.model.DTO;
import software.xdev.mockserver.serialization.model.NotDTO;
import software.xdev.mockserver.serialization.model.ParameterBodyDTO;
import software.xdev.mockserver.serialization.model.RegexBodyDTO;
import software.xdev.mockserver.serialization.model.StringBodyDTO;
import software.xdev.mockserver.util.StringUtils;

public abstract class BodyDTO
extends NotDTO
implements DTO<Body<?>> {
    private static final Logger LOG = LoggerFactory.getLogger(BodyDTO.class);
    private static final ObjectMapper OBJECT_MAPPER = ObjectMapperFactory.createObjectMapper();
    private final Body.Type type;
    private Boolean optional;

    protected BodyDTO(Body.Type type, Boolean not) {
        super(not);
        this.type = type;
    }

    public static BodyDTO createDTO(Body<?> body) {
        BodyDTO result = null;
        if (body instanceof BinaryBody) {
            BinaryBody typedDTO = (BinaryBody)body;
            result = new BinaryBodyDTO(typedDTO, typedDTO.getNot());
        } else if (body instanceof ParameterBody) {
            ParameterBody typedDTO = (ParameterBody)body;
            result = new ParameterBodyDTO(typedDTO, typedDTO.getNot());
        } else if (body instanceof RegexBody) {
            RegexBody typedDTO = (RegexBody)body;
            result = new RegexBodyDTO(typedDTO, typedDTO.getNot());
        } else if (body instanceof StringBody) {
            StringBody typedDTO = (StringBody)body;
            result = new StringBodyDTO(typedDTO, typedDTO.getNot());
        }
        if (result != null) {
            result.withOptional(body.getOptional());
        }
        return result;
    }

    public static String toString(BodyDTO body) {
        if (body instanceof BinaryBodyDTO) {
            BinaryBodyDTO typedDTO = (BinaryBodyDTO)body;
            return Base64.getEncoder().encodeToString(typedDTO.getBase64Bytes());
        }
        if (body instanceof ParameterBodyDTO) {
            ParameterBodyDTO typedDTO = (ParameterBodyDTO)body;
            try {
                return OBJECT_MAPPER.writeValueAsString(typedDTO.getParameters().getMultimap());
            }
            catch (Exception ex) {
                LOG.error("Serialising parameter body into json string for javascript template {}", StringUtils.isNotBlank(ex.getMessage()) ? " " + ex.getMessage() : "", (Object)ex);
                return "";
            }
        }
        if (body instanceof RegexBodyDTO) {
            RegexBodyDTO typedDTO = (RegexBodyDTO)body;
            return typedDTO.getRegex();
        }
        if (body instanceof StringBodyDTO) {
            StringBodyDTO typedDTO = (StringBodyDTO)body;
            return typedDTO.getString();
        }
        return "";
    }

    public Body.Type getType() {
        return this.type;
    }

    public Boolean getOptional() {
        return this.optional;
    }

    public BodyDTO withOptional(Boolean optional) {
        this.optional = optional;
        return this;
    }

    @Override
    public abstract Body<?> buildObject();

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BodyDTO)) {
            return false;
        }
        BodyDTO bodyDTO = (BodyDTO)o;
        if (!super.equals(o)) {
            return false;
        }
        return this.getType() == bodyDTO.getType() && Objects.equals(this.getOptional(), bodyDTO.getOptional());
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.getType(), this.getOptional()});
    }
}

