/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.mockserver.closurecallback.websocketregistry;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import java.util.Collections;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.xdev.mockserver.closurecallback.websocketclient.WebSocketException;
import software.xdev.mockserver.closurecallback.websocketregistry.LocalCallbackRegistry;
import software.xdev.mockserver.closurecallback.websocketregistry.WebSocketRequestCallback;
import software.xdev.mockserver.closurecallback.websocketregistry.WebSocketResponseCallback;
import software.xdev.mockserver.collections.CircularHashMap;
import software.xdev.mockserver.configuration.Configuration;
import software.xdev.mockserver.model.HttpRequest;
import software.xdev.mockserver.model.HttpRequestAndHttpResponse;
import software.xdev.mockserver.model.HttpResponse;
import software.xdev.mockserver.serialization.WebSocketMessageSerializer;
import software.xdev.mockserver.serialization.model.WebSocketClientIdDTO;
import software.xdev.mockserver.serialization.model.WebSocketErrorDTO;

public class WebSocketClientRegistry {
    private static final Logger LOG = LoggerFactory.getLogger(WebSocketClientRegistry.class);
    public static final String WEB_SOCKET_CORRELATION_ID_HEADER_NAME = "WebSocketCorrelationId";
    private final WebSocketMessageSerializer webSocketMessageSerializer = new WebSocketMessageSerializer();
    private final Map<String, Channel> clientRegistry;
    private final Map<String, WebSocketResponseCallback> responseCallbackRegistry;
    private final Map<String, WebSocketRequestCallback> forwardCallbackRegistry;

    public WebSocketClientRegistry(Configuration configuration) {
        this.clientRegistry = Collections.synchronizedMap(new CircularHashMap(configuration.maxWebSocketExpectations()));
        this.responseCallbackRegistry = new CircularHashMap<String, WebSocketResponseCallback>(configuration.maxWebSocketExpectations());
        this.forwardCallbackRegistry = new CircularHashMap<String, WebSocketRequestCallback>(configuration.maxWebSocketExpectations());
    }

    public void receivedTextWebSocketFrame(TextWebSocketFrame textWebSocketFrame) {
        block11: {
            try {
                Object deserializedMessage = this.webSocketMessageSerializer.deserialize(textWebSocketFrame.text());
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Received message over websocket {}", deserializedMessage);
                }
                if (deserializedMessage instanceof HttpResponse) {
                    HttpResponse httpResponse = (HttpResponse)deserializedMessage;
                    String firstHeader = httpResponse.getFirstHeader(WEB_SOCKET_CORRELATION_ID_HEADER_NAME);
                    WebSocketResponseCallback webSocketResponseCallback = this.responseCallbackRegistry.get(firstHeader);
                    if (webSocketResponseCallback != null) {
                        webSocketResponseCallback.handle(httpResponse);
                    }
                    break block11;
                }
                if (deserializedMessage instanceof HttpRequest) {
                    HttpRequest httpRequest = (HttpRequest)deserializedMessage;
                    String firstHeader = httpRequest.getFirstHeader(WEB_SOCKET_CORRELATION_ID_HEADER_NAME);
                    WebSocketRequestCallback webSocketRequestCallback = this.forwardCallbackRegistry.get(firstHeader);
                    if (webSocketRequestCallback != null) {
                        webSocketRequestCallback.handle(httpRequest);
                    }
                    break block11;
                }
                if (deserializedMessage instanceof WebSocketErrorDTO) {
                    WebSocketErrorDTO webSocketErrorDTO = (WebSocketErrorDTO)deserializedMessage;
                    if (this.forwardCallbackRegistry.containsKey(webSocketErrorDTO.getWebSocketCorrelationId())) {
                        this.forwardCallbackRegistry.get(webSocketErrorDTO.getWebSocketCorrelationId()).handleError(HttpResponse.response().withStatusCode(404).withBody(webSocketErrorDTO.getMessage()));
                    } else if (this.responseCallbackRegistry.containsKey(webSocketErrorDTO.getWebSocketCorrelationId())) {
                        this.responseCallbackRegistry.get(webSocketErrorDTO.getWebSocketCorrelationId()).handle(HttpResponse.response().withStatusCode(404).withBody(webSocketErrorDTO.getMessage()));
                    }
                    break block11;
                }
                throw new WebSocketException("Unsupported web socket message " + String.valueOf(deserializedMessage));
            }
            catch (Exception e) {
                throw new WebSocketException("Exception while receiving web socket message" + textWebSocketFrame.text(), e);
            }
        }
    }

    public void registerClient(String clientId, ChannelHandlerContext ctx) {
        try {
            ctx.channel().writeAndFlush((Object)new TextWebSocketFrame(this.webSocketMessageSerializer.serialize(new WebSocketClientIdDTO().setClientId(clientId))));
        }
        catch (Exception e) {
            throw new WebSocketException("Exception while sending web socket registration client id message to client " + clientId, e);
        }
        this.clientRegistry.put(clientId, ctx.channel());
        if (LOG.isTraceEnabled()) {
            LOG.trace("Registering client {}", (Object)clientId);
        }
    }

    public void unregisterClient(String clientId) {
        LocalCallbackRegistry.unregisterCallback(clientId);
        Channel removeChannel = this.clientRegistry.remove(clientId);
        if (removeChannel != null && removeChannel.isOpen()) {
            removeChannel.close();
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("Unregistering client {}", (Object)clientId);
        }
    }

    public void registerResponseCallbackHandler(String webSocketCorrelationId, WebSocketResponseCallback expectationResponseCallback) {
        this.responseCallbackRegistry.put(webSocketCorrelationId, expectationResponseCallback);
        if (LOG.isTraceEnabled()) {
            LOG.trace("Registering response callback {}", (Object)webSocketCorrelationId);
        }
    }

    public void unregisterResponseCallbackHandler(String webSocketCorrelationId) {
        this.responseCallbackRegistry.remove(webSocketCorrelationId);
        if (LOG.isTraceEnabled()) {
            LOG.trace("Unregistering response callback {}", (Object)webSocketCorrelationId);
        }
    }

    public void registerForwardCallbackHandler(String webSocketCorrelationId, WebSocketRequestCallback expectationForwardCallback) {
        this.forwardCallbackRegistry.put(webSocketCorrelationId, expectationForwardCallback);
        if (LOG.isTraceEnabled()) {
            LOG.trace("Registering forward callback {}", (Object)webSocketCorrelationId);
        }
    }

    public void unregisterForwardCallbackHandler(String webSocketCorrelationId) {
        this.forwardCallbackRegistry.remove(webSocketCorrelationId);
        if (LOG.isTraceEnabled()) {
            LOG.trace("Unregistering forward callback {}", (Object)webSocketCorrelationId);
        }
    }

    public boolean sendClientMessage(String clientId, HttpRequest httpRequest, HttpResponse httpResponse) {
        try {
            if (this.clientRegistry.containsKey(clientId)) {
                if (httpResponse == null) {
                    if (LOG.isTraceEnabled()) {
                        LOG.trace("Sending message {} to client {}", (Object)httpRequest, (Object)clientId);
                    }
                    this.clientRegistry.get(clientId).writeAndFlush((Object)new TextWebSocketFrame(this.webSocketMessageSerializer.serialize(httpRequest)));
                } else {
                    HttpRequestAndHttpResponse httpRequestAndHttpResponse = new HttpRequestAndHttpResponse().withHttpRequest(httpRequest).withHttpResponse(httpResponse);
                    if (LOG.isTraceEnabled()) {
                        LOG.trace("Sending message {} to client {}", (Object)httpRequestAndHttpResponse, (Object)clientId);
                    }
                    this.clientRegistry.get(clientId).writeAndFlush((Object)new TextWebSocketFrame(this.webSocketMessageSerializer.serialize(httpRequestAndHttpResponse)));
                }
                return true;
            }
            if (LOG.isWarnEnabled()) {
                LOG.warn("Client {} not found for request {} client registry only contains {}", new Object[]{clientId, httpRequest, this.clientRegistry});
            }
            return false;
        }
        catch (Exception e) {
            throw new WebSocketException("Exception while sending web socket message " + String.valueOf(httpRequest) + " to client " + clientId, e);
        }
    }

    public synchronized void reset() {
        this.forwardCallbackRegistry.clear();
        this.responseCallbackRegistry.clear();
        this.clientRegistry.forEach((clientId, channel) -> {
            LocalCallbackRegistry.unregisterCallback(clientId);
            channel.close();
        });
        this.clientRegistry.clear();
    }
}

