/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.mockserver.matchers;

import java.util.Objects;

public class Times {
    private static final Times TIMES_UNLIMITED = new Times(-1, true){

        @Override
        public int getRemainingTimes() {
            return -1;
        }

        @Override
        public boolean isUnlimited() {
            return true;
        }

        @Override
        public boolean greaterThenZero() {
            return true;
        }

        @Override
        public boolean decrement() {
            return false;
        }
    };
    private int hashCode;
    private int remainingTimes;
    private final boolean unlimited;

    private Times(int remainingTimes, boolean unlimited) {
        this.remainingTimes = remainingTimes;
        this.unlimited = unlimited;
    }

    public static Times unlimited() {
        return TIMES_UNLIMITED;
    }

    public static Times once() {
        return new Times(1, false);
    }

    public static Times exactly(int count) {
        return new Times(count, false);
    }

    public int getRemainingTimes() {
        return this.remainingTimes;
    }

    public boolean isUnlimited() {
        return this.unlimited;
    }

    public boolean greaterThenZero() {
        return this.unlimited || this.remainingTimes > 0;
    }

    public boolean decrement() {
        if (!this.unlimited) {
            --this.remainingTimes;
            return true;
        }
        return false;
    }

    public Times clone() {
        if (this.unlimited) {
            return Times.unlimited();
        }
        return Times.exactly(this.remainingTimes);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (this.hashCode() != o.hashCode()) {
            return false;
        }
        Times times = (Times)o;
        return this.remainingTimes == times.remainingTimes && this.unlimited == times.unlimited;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = Objects.hash(this.remainingTimes, this.unlimited);
        }
        return this.hashCode;
    }
}

