/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.mockserver.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import software.xdev.mockserver.model.BodyWithContentType;
import software.xdev.mockserver.model.Not;

public abstract class Body<T>
extends Not {
    private int hashCode;
    private final Type type;
    private Boolean optional;

    protected Body(Type type) {
        this.type = type;
    }

    public Type getType() {
        return this.type;
    }

    public Boolean getOptional() {
        return this.optional;
    }

    public Body<T> withOptional(Boolean optional) {
        this.optional = optional;
        return this;
    }

    public abstract T getValue();

    @JsonIgnore
    public byte[] getRawBytes() {
        return this.toString().getBytes(StandardCharsets.UTF_8);
    }

    @JsonIgnore
    public Charset getCharset(Charset defaultIfNotSet) {
        if (this instanceof BodyWithContentType) {
            return this.getCharset(defaultIfNotSet);
        }
        return defaultIfNotSet;
    }

    public String getContentType() {
        if (this instanceof BodyWithContentType) {
            return this.getContentType();
        }
        return null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (this.hashCode() != o.hashCode()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Body body = (Body)o;
        return this.type == body.type && Objects.equals(this.optional, body.optional);
    }

    @Override
    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = Objects.hash(new Object[]{super.hashCode(), this.type, this.optional});
        }
        return this.hashCode;
    }

    public static enum Type {
        BINARY,
        PARAMETERS,
        REGEX,
        STRING;

    }
}

