/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.mockserver.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.cookie.ClientCookieDecoder;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import software.xdev.mockserver.model.Action;
import software.xdev.mockserver.model.BinaryBody;
import software.xdev.mockserver.model.BodyWithContentType;
import software.xdev.mockserver.model.ConnectionOptions;
import software.xdev.mockserver.model.Cookie;
import software.xdev.mockserver.model.Cookies;
import software.xdev.mockserver.model.Header;
import software.xdev.mockserver.model.Headers;
import software.xdev.mockserver.model.HttpMessage;
import software.xdev.mockserver.model.HttpResponseModifier;
import software.xdev.mockserver.model.HttpStatusCode;
import software.xdev.mockserver.model.MediaType;
import software.xdev.mockserver.model.NottableString;
import software.xdev.mockserver.model.StringBody;

public class HttpResponse
extends Action<HttpResponse>
implements HttpMessage<HttpResponse, BodyWithContentType> {
    private int hashCode;
    private Integer statusCode;
    private String reasonPhrase;
    private BodyWithContentType body;
    private Headers headers;
    private Cookies cookies;
    private ConnectionOptions connectionOptions;
    private Integer streamId;

    public static HttpResponse response() {
        return new HttpResponse();
    }

    public static HttpResponse response(String body) {
        return new HttpResponse().withStatusCode(HttpStatusCode.OK_200.code()).withReasonPhrase(HttpStatusCode.OK_200.reasonPhrase()).withBody(body);
    }

    public static HttpResponse notFoundResponse() {
        return new HttpResponse().withStatusCode(HttpStatusCode.NOT_FOUND_404.code()).withReasonPhrase(HttpStatusCode.NOT_FOUND_404.reasonPhrase());
    }

    public HttpResponse withStatusCode(Integer statusCode) {
        this.statusCode = statusCode;
        this.hashCode = 0;
        return this;
    }

    public Integer getStatusCode() {
        return this.statusCode;
    }

    public HttpResponse withReasonPhrase(String reasonPhrase) {
        this.reasonPhrase = reasonPhrase;
        this.hashCode = 0;
        return this;
    }

    public String getReasonPhrase() {
        return this.reasonPhrase;
    }

    @Override
    public HttpResponse withBody(String body) {
        if (body != null) {
            this.body = new StringBody(body);
            this.hashCode = 0;
        }
        return this;
    }

    @Override
    public HttpResponse withBody(String body, Charset charset) {
        if (body != null) {
            this.body = new StringBody(body, charset);
            this.hashCode = 0;
        }
        return this;
    }

    public HttpResponse withBody(String body, MediaType contentType) {
        if (body != null) {
            this.body = new StringBody(body, contentType);
            this.hashCode = 0;
        }
        return this;
    }

    @Override
    public HttpResponse withBody(byte[] body) {
        this.body = new BinaryBody(body);
        this.hashCode = 0;
        return this;
    }

    @Override
    public HttpResponse withBody(BodyWithContentType body) {
        this.body = body;
        this.hashCode = 0;
        return this;
    }

    @Override
    public BodyWithContentType getBody() {
        return this.body;
    }

    @Override
    @JsonIgnore
    public byte[] getBodyAsRawBytes() {
        return this.body != null ? this.body.getRawBytes() : new byte[]{};
    }

    @Override
    @JsonIgnore
    public String getBodyAsString() {
        if (this.body != null) {
            return this.body.toString();
        }
        return null;
    }

    @Override
    public Headers getHeaders() {
        return this.headers;
    }

    private Headers getOrCreateHeaders() {
        if (this.headers == null) {
            this.headers = new Headers(new Header[0]);
            this.hashCode = 0;
        }
        return this.headers;
    }

    @Override
    public HttpResponse withHeaders(Headers headers) {
        this.headers = headers == null || headers.isEmpty() ? null : headers;
        this.hashCode = 0;
        return this;
    }

    @Override
    public HttpResponse withHeaders(List<Header> headers) {
        this.getOrCreateHeaders().withEntries(headers);
        this.hashCode = 0;
        return this;
    }

    @Override
    public HttpResponse withHeaders(Header ... headers) {
        this.getOrCreateHeaders().withEntries(headers);
        this.hashCode = 0;
        return this;
    }

    @Override
    public HttpResponse withHeader(Header header) {
        this.getOrCreateHeaders().withEntry(header);
        this.hashCode = 0;
        return this;
    }

    @Override
    public HttpResponse withHeader(String name, String ... values) {
        String[] stringArray;
        Headers headers = this.getOrCreateHeaders();
        if (values.length == 0) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = ".*";
        } else {
            stringArray = values;
        }
        headers.withEntry(name, stringArray);
        this.hashCode = 0;
        return this;
    }

    @Override
    public HttpResponse withHeader(NottableString name, NottableString ... values) {
        NottableString[] nottableStringArray;
        Headers headers = this.getOrCreateHeaders();
        if (values.length == 0) {
            NottableString[] nottableStringArray2 = new NottableString[1];
            nottableStringArray = nottableStringArray2;
            nottableStringArray2[0] = NottableString.string(".*");
        } else {
            nottableStringArray = values;
        }
        headers.withEntry(Header.header(name, nottableStringArray));
        this.hashCode = 0;
        return this;
    }

    @Override
    public HttpResponse withContentType(MediaType mediaType) {
        this.getOrCreateHeaders().withEntry(Header.header(HttpHeaderNames.CONTENT_TYPE.toString(), mediaType.toString()));
        this.hashCode = 0;
        return this;
    }

    @Override
    public HttpResponse replaceHeader(Header header) {
        this.getOrCreateHeaders().replaceEntry(header);
        this.hashCode = 0;
        return this;
    }

    public HttpResponse replaceHeader(String name, String ... values) {
        String[] stringArray;
        Headers headers = this.getOrCreateHeaders();
        if (values.length == 0) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = ".*";
        } else {
            stringArray = values;
        }
        headers.replaceEntry(name, stringArray);
        this.hashCode = 0;
        return this;
    }

    @Override
    public List<Header> getHeaderList() {
        if (this.headers != null) {
            return this.headers.getEntries();
        }
        return Collections.emptyList();
    }

    public Map<NottableString, List<NottableString>> getHeaderMultimap() {
        if (this.headers != null) {
            return this.headers.getMultimap();
        }
        return null;
    }

    @Override
    public List<String> getHeader(String name) {
        if (this.headers != null) {
            return this.headers.getValues(name);
        }
        return Collections.emptyList();
    }

    @Override
    public String getFirstHeader(String name) {
        if (this.headers != null) {
            return this.headers.getFirstValue(name);
        }
        return "";
    }

    @Override
    public boolean containsHeader(String name) {
        if (this.headers != null) {
            return this.headers.containsEntry(name);
        }
        return false;
    }

    @Override
    public HttpResponse removeHeader(String name) {
        if (this.headers != null) {
            this.headers.remove(name);
            this.hashCode = 0;
        }
        return this;
    }

    @Override
    public HttpResponse removeHeader(NottableString name) {
        if (this.headers != null) {
            this.headers.remove(name);
            this.hashCode = 0;
        }
        return this;
    }

    public boolean containsHeader(String name, String value) {
        if (this.headers != null) {
            return this.headers.containsEntry(name, value);
        }
        return false;
    }

    @Override
    public Cookies getCookies() {
        return this.cookies;
    }

    private Cookies getOrCreateCookies() {
        if (this.cookies == null) {
            this.cookies = new Cookies(new Cookie[0]);
            this.hashCode = 0;
        }
        return this.cookies;
    }

    @Override
    public HttpResponse withCookies(Cookies cookies) {
        this.cookies = cookies == null || cookies.isEmpty() ? null : cookies;
        this.hashCode = 0;
        return this;
    }

    @Override
    public HttpResponse withCookies(List<Cookie> cookies) {
        this.getOrCreateCookies().withEntries(cookies);
        this.hashCode = 0;
        return this;
    }

    @Override
    public HttpResponse withCookies(Cookie ... cookies) {
        this.getOrCreateCookies().withEntries(cookies);
        this.hashCode = 0;
        return this;
    }

    @Override
    public HttpResponse withCookie(Cookie cookie) {
        this.getOrCreateCookies().withEntry(cookie);
        this.hashCode = 0;
        return this;
    }

    @Override
    public HttpResponse withCookie(String name, String value) {
        this.getOrCreateCookies().withEntry(name, value);
        this.hashCode = 0;
        return this;
    }

    @Override
    public HttpResponse withCookie(NottableString name, NottableString value) {
        this.getOrCreateCookies().withEntry(name, value);
        this.hashCode = 0;
        return this;
    }

    @Override
    public List<Cookie> getCookieList() {
        if (this.cookies != null) {
            return this.cookies.getEntries();
        }
        return Collections.emptyList();
    }

    public Map<NottableString, NottableString> getCookieMap() {
        if (this.cookies != null) {
            return this.cookies.getMap();
        }
        return null;
    }

    public boolean cookieHeaderDoesNotAlreadyExists(Cookie cookieValue) {
        List<String> setCookieHeaders = this.getHeader(HttpHeaderNames.SET_COOKIE.toString());
        for (String setCookieHeader : setCookieHeaders) {
            String existingCookieName = ClientCookieDecoder.LAX.decode(setCookieHeader).name();
            String existingCookieValue = ClientCookieDecoder.LAX.decode(setCookieHeader).value();
            if (!existingCookieName.equalsIgnoreCase(cookieValue.getName().getValue()) || !existingCookieValue.equalsIgnoreCase(cookieValue.getValue().getValue())) continue;
            return false;
        }
        return true;
    }

    public boolean cookieHeaderDoesNotAlreadyExists(String name, String value) {
        List<String> setCookieHeaders = this.getHeader(HttpHeaderNames.SET_COOKIE.toString());
        for (String setCookieHeader : setCookieHeaders) {
            String existingCookieName = ClientCookieDecoder.LAX.decode(setCookieHeader).name();
            String existingCookieValue = ClientCookieDecoder.LAX.decode(setCookieHeader).value();
            if (!existingCookieName.equalsIgnoreCase(name) || !existingCookieValue.equalsIgnoreCase(value)) continue;
            return false;
        }
        return true;
    }

    public HttpResponse withConnectionOptions(ConnectionOptions connectionOptions) {
        this.connectionOptions = connectionOptions;
        this.hashCode = 0;
        return this;
    }

    public ConnectionOptions getConnectionOptions() {
        return this.connectionOptions;
    }

    public HttpResponse withStreamId(Integer streamId) {
        this.streamId = streamId;
        this.hashCode = 0;
        return this;
    }

    public Integer getStreamId() {
        return this.streamId;
    }

    @Override
    @JsonIgnore
    public Action.Type getType() {
        return Action.Type.RESPONSE;
    }

    public HttpResponse shallowClone() {
        return ((HttpResponse)HttpResponse.response().withStatusCode(this.statusCode).withReasonPhrase(this.reasonPhrase).withBody(this.body).withHeaders(this.headers).withCookies(this.cookies).withDelay(this.getDelay())).withConnectionOptions(this.connectionOptions).withStreamId(this.streamId);
    }

    public HttpResponse clone() {
        return ((HttpResponse)HttpResponse.response().withStatusCode(this.statusCode).withReasonPhrase(this.reasonPhrase).withBody(this.body).withHeaders(this.headers != null ? this.headers.clone() : null).withCookies(this.cookies != null ? this.cookies.clone() : null).withDelay(this.getDelay())).withConnectionOptions(this.connectionOptions).withStreamId(this.streamId);
    }

    public HttpResponse update(HttpResponse responseOverride, HttpResponseModifier responseModifier) {
        if (responseOverride != null) {
            if (responseOverride.getStatusCode() != null) {
                this.withStatusCode(responseOverride.getStatusCode());
            }
            if (responseOverride.getReasonPhrase() != null) {
                this.withReasonPhrase(responseOverride.getReasonPhrase());
            }
            for (Header header : responseOverride.getHeaderList()) {
                this.getOrCreateHeaders().replaceEntry(header);
            }
            for (Cookie cookie : responseOverride.getCookieList()) {
                this.withCookie(cookie);
            }
            if (responseOverride.getBody() != null) {
                this.withBody(responseOverride.getBody());
            }
            if (responseOverride.getConnectionOptions() != null) {
                this.withConnectionOptions(responseOverride.getConnectionOptions());
            }
            if (responseOverride.getStreamId() != null) {
                this.withStreamId(responseOverride.getStreamId());
            }
            this.hashCode = 0;
        }
        if (responseModifier != null) {
            if (responseModifier.getHeaders() != null) {
                this.withHeaders(responseModifier.getHeaders().update(this.getHeaders()));
            }
            if (responseModifier.getCookies() != null) {
                this.withCookies(responseModifier.getCookies().update(this.getCookies()));
            }
        }
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (this.hashCode() != o.hashCode()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        HttpResponse that = (HttpResponse)o;
        return Objects.equals(this.statusCode, that.statusCode) && Objects.equals(this.reasonPhrase, that.reasonPhrase) && Objects.equals(this.body, that.body) && Objects.equals(this.headers, that.headers) && Objects.equals(this.cookies, that.cookies) && Objects.equals(this.connectionOptions, that.connectionOptions) && Objects.equals(this.streamId, that.streamId);
    }

    @Override
    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = Objects.hash(super.hashCode(), this.statusCode, this.reasonPhrase, this.body, this.headers, this.cookies, this.connectionOptions, this.streamId);
        }
        return this.hashCode;
    }
}

