/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.mockserver.serialization.deserializers.body;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.xdev.mockserver.model.BinaryBody;
import software.xdev.mockserver.model.Body;
import software.xdev.mockserver.model.MediaType;
import software.xdev.mockserver.model.ParameterBody;
import software.xdev.mockserver.model.ParameterStyle;
import software.xdev.mockserver.model.Parameters;
import software.xdev.mockserver.model.RegexBody;
import software.xdev.mockserver.model.StringBody;
import software.xdev.mockserver.serialization.ObjectMapperFactory;
import software.xdev.mockserver.serialization.model.BinaryBodyDTO;
import software.xdev.mockserver.serialization.model.BodyDTO;
import software.xdev.mockserver.serialization.model.ParameterBodyDTO;
import software.xdev.mockserver.serialization.model.RegexBodyDTO;
import software.xdev.mockserver.serialization.model.StringBodyDTO;
import software.xdev.mockserver.util.StringUtils;

public class BodyDTODeserializer
extends StdDeserializer<BodyDTO> {
    private static final Logger LOG = LoggerFactory.getLogger(BodyDTODeserializer.class);
    private static final Map<String, Body.Type> FIELD_NAME_TO_TYPE = new HashMap<String, Body.Type>(Map.ofEntries(Map.entry("base64bytes", Body.Type.BINARY), Map.entry("parameters", Body.Type.PARAMETERS), Map.entry("regex", Body.Type.REGEX), Map.entry("string", Body.Type.STRING)));
    private static final Base64.Decoder BASE64_DECODER = Base64.getDecoder();
    private static ObjectWriter objectWriter;
    private static ObjectMapper objectMapper;
    private static ObjectWriter jsonBodyObjectWriter;

    public BodyDTODeserializer() {
        super(BodyDTO.class);
    }

    public BodyDTO deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
        BodyDTO result = null;
        JsonToken currentToken = jsonParser.getCurrentToken();
        String valueJsonValue = "";
        byte[] rawBytes = null;
        Enum type = null;
        Boolean not = null;
        Boolean optional = null;
        MediaType contentType = null;
        Charset charset = null;
        boolean subString = false;
        Parameters parameters = null;
        if (currentToken == JsonToken.START_OBJECT) {
            Map body = (Map)ctxt.readValue(jsonParser, Map.class);
            for (Map.Entry entry : body.entrySet()) {
                String key;
                block54: {
                    block53: {
                        block52: {
                            block51: {
                                block50: {
                                    block49: {
                                        Object v;
                                        block48: {
                                            Object k = entry.getKey();
                                            if (!(k instanceof String)) continue;
                                            key = (String)k;
                                            if ("type".equalsIgnoreCase(key)) {
                                                try {
                                                    type = Body.Type.valueOf(String.valueOf(entry.getValue()));
                                                }
                                                catch (IllegalArgumentException iae) {
                                                    if (!LOG.isDebugEnabled()) break block48;
                                                    LOG.debug("Ignoring invalid value for \"type\" field of \"{}\"", entry.getValue());
                                                }
                                            }
                                        }
                                        if (this.containsIgnoreCase(key, "string", "regex", "base64Bytes") && type != Body.Type.PARAMETERS) {
                                            String fieldName = String.valueOf(entry.getKey()).toLowerCase();
                                            if (FIELD_NAME_TO_TYPE.containsKey(fieldName)) {
                                                type = FIELD_NAME_TO_TYPE.get(fieldName);
                                            }
                                            if (Map.class.isAssignableFrom(entry.getValue().getClass()) || this.containsIgnoreCase(key, "json", "jsonSchema") && !String.class.isAssignableFrom(entry.getValue().getClass())) {
                                                if (jsonBodyObjectWriter == null) {
                                                    jsonBodyObjectWriter = ObjectMapperFactory.buildObjectMapperWithoutRemovingEmptyValues().writerWithDefaultPrettyPrinter();
                                                }
                                                valueJsonValue = jsonBodyObjectWriter.writeValueAsString(entry.getValue());
                                            } else {
                                                valueJsonValue = String.valueOf(entry.getValue());
                                            }
                                        }
                                        if (this.containsIgnoreCase(key, "rawBytes", "base64Bytes") && (v = entry.getValue()) instanceof String) {
                                            String s = (String)v;
                                            try {
                                                rawBytes = BASE64_DECODER.decode(s);
                                            }
                                            catch (Exception ex) {
                                                if (!LOG.isDebugEnabled()) break block49;
                                                LOG.debug("Invalid base64 encoded rawBytes with value \"{}\"", entry.getValue(), (Object)ex);
                                            }
                                        }
                                    }
                                    if ("not".equalsIgnoreCase(key)) {
                                        not = Boolean.parseBoolean(String.valueOf(entry.getValue()));
                                    }
                                    if ("optional".equalsIgnoreCase(key)) {
                                        optional = Boolean.parseBoolean(String.valueOf(entry.getValue()));
                                    }
                                    if ("optional".equalsIgnoreCase(key)) {
                                        try {
                                            subString = Boolean.parseBoolean(String.valueOf(entry.getValue()));
                                        }
                                        catch (IllegalArgumentException uce) {
                                            if (!LOG.isDebugEnabled()) break block50;
                                            LOG.debug("Ignoring unsupported boolean with value \"{}\"", entry.getValue(), (Object)uce);
                                        }
                                    }
                                }
                                if ("parameterStyles".equalsIgnoreCase(key) && entry.getValue() instanceof Map) {
                                    try {
                                        HashMap<String, ParameterStyle> parameterStyles = new HashMap<String, ParameterStyle>();
                                        for (Map.Entry parameterStyle : ((Map)entry.getValue()).entrySet()) {
                                            parameterStyles.put(String.valueOf(parameterStyle.getKey()), ParameterStyle.valueOf(String.valueOf(parameterStyle.getValue())));
                                        }
                                    }
                                    catch (IllegalArgumentException uce) {
                                        if (!LOG.isDebugEnabled()) break block51;
                                        LOG.debug("Ignoring unsupported boolean with value \"{}\"", entry.getValue(), (Object)uce);
                                    }
                                }
                            }
                            if ("namespacePrefixes".equalsIgnoreCase(key) && entry.getValue() instanceof Map) {
                                try {
                                    HashMap<String, String> namespacePrefixes = new HashMap<String, String>();
                                    for (Map.Entry namespacePrefixEntry : ((Map)entry.getValue()).entrySet()) {
                                        namespacePrefixes.put(String.valueOf(namespacePrefixEntry.getKey()), String.valueOf(namespacePrefixEntry.getValue()));
                                    }
                                }
                                catch (IllegalArgumentException uce) {
                                    if (!LOG.isDebugEnabled()) break block52;
                                    LOG.debug("Ignoring unsupported namespacePrefixEntry with value \"{}\"", entry.getValue(), (Object)uce);
                                }
                            }
                        }
                        if ("contentType".equalsIgnoreCase(key)) {
                            try {
                                MediaType parsedMediaTypeHeader;
                                String mediaTypeHeader = String.valueOf(entry.getValue());
                                if (StringUtils.isNotBlank(mediaTypeHeader) && StringUtils.isNotBlank((parsedMediaTypeHeader = MediaType.parse(mediaTypeHeader)).toString())) {
                                    contentType = parsedMediaTypeHeader;
                                }
                            }
                            catch (IllegalArgumentException uce) {
                                if (!LOG.isDebugEnabled()) break block53;
                                LOG.debug("Ignoring unsupported MediaType with value \"{}\"", entry.getValue(), (Object)uce);
                            }
                        }
                    }
                    if ("charset".equalsIgnoreCase(key)) {
                        try {
                            charset = Charset.forName(String.valueOf(entry.getValue()));
                        }
                        catch (UnsupportedCharsetException uce) {
                            if (LOG.isDebugEnabled()) {
                                LOG.debug("Ignoring unsupported Charset with value \"{}\"", entry.getValue(), (Object)uce);
                            }
                        }
                        catch (IllegalCharsetNameException icne) {
                            if (!LOG.isDebugEnabled()) break block54;
                            LOG.debug("Ignoring invalid Charset with value \"{}\"", entry.getValue(), (Object)icne);
                        }
                    }
                }
                if (!"parameters".equalsIgnoreCase(key)) continue;
                if (objectMapper == null) {
                    objectMapper = ObjectMapperFactory.createObjectMapper();
                }
                if (objectWriter == null) {
                    objectWriter = objectMapper.writerWithDefaultPrettyPrinter();
                }
                parameters = (Parameters)objectMapper.readValue(objectWriter.writeValueAsString(entry.getValue()), Parameters.class);
            }
            if (type != null) {
                switch (1.$SwitchMap$software$xdev$mockserver$model$Body$Type[type.ordinal()]) {
                    case 1: {
                        if (contentType != null && StringUtils.isNotBlank(contentType.toString())) {
                            result = new BinaryBodyDTO(new BinaryBody(rawBytes, contentType), not);
                            break;
                        }
                        result = new BinaryBodyDTO(new BinaryBody(rawBytes), not);
                        break;
                    }
                    case 2: {
                        result = new ParameterBodyDTO(new ParameterBody(parameters), not);
                        break;
                    }
                    case 3: {
                        result = new RegexBodyDTO(new RegexBody(valueJsonValue), not);
                        break;
                    }
                    case 4: {
                        result = contentType != null && StringUtils.isNotBlank(contentType.toString()) ? new StringBodyDTO(new StringBody(valueJsonValue, rawBytes, subString, contentType), not) : (charset != null ? new StringBodyDTO(new StringBody(valueJsonValue, rawBytes, subString, StringBody.DEFAULT_CONTENT_TYPE.withCharset(charset)), not) : new StringBodyDTO(new StringBody(valueJsonValue, rawBytes, subString, null), not));
                    }
                }
            }
        } else if (currentToken == JsonToken.VALUE_STRING) {
            result = new StringBodyDTO(new StringBody(jsonParser.getText()));
        }
        if (result != null) {
            result.withOptional(optional);
        }
        return result;
    }

    private boolean containsIgnoreCase(String valueToMatch, String ... listOfValues) {
        for (String item : listOfValues) {
            if (!item.equalsIgnoreCase(valueToMatch)) continue;
            return true;
        }
        return false;
    }
}

