/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.mockserver.serialization.deserializers.condition;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.xdev.mockserver.matchers.TimeToLive;
import software.xdev.mockserver.serialization.model.TimeToLiveDTO;

public class TimeToLiveDTODeserializer
extends StdDeserializer<TimeToLiveDTO> {
    private static final Logger LOG = LoggerFactory.getLogger(TimeToLiveDTODeserializer.class);

    public TimeToLiveDTODeserializer() {
        super(TimeToLiveDTO.class);
    }

    public TimeToLiveDTO deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
        TimeToLiveDTO timeToLiveDTO = null;
        TimeToLive timeToLive = null;
        long ttl = 0L;
        boolean unlimited = false;
        JsonNode timeToLiveDTONode = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
        JsonNode unlimitedNode = timeToLiveDTONode.get("unlimited");
        if (unlimitedNode != null) {
            unlimited = unlimitedNode.asBoolean();
        }
        if (!unlimited) {
            block9: {
                JsonNode timeUnitNode;
                JsonNode timeToLiveNode = timeToLiveDTONode.get("timeToLive");
                if (timeToLiveNode != null) {
                    ttl = timeToLiveNode.asLong();
                }
                if ((timeUnitNode = timeToLiveDTONode.get("timeUnit")) != null) {
                    try {
                        TimeUnit timeUnit = Enum.valueOf(TimeUnit.class, timeUnitNode.asText());
                        timeToLive = TimeToLive.exactly(timeUnit, ttl);
                    }
                    catch (IllegalArgumentException iae) {
                        if (!LOG.isTraceEnabled()) break block9;
                        LOG.trace("Exception parsing TimeToLiveDTO timeUnit", (Throwable)iae);
                    }
                }
            }
            if (timeToLive != null) {
                JsonNode endDateNode = timeToLiveDTONode.get("endDate");
                if (endDateNode != null) {
                    long endDate = endDateNode.asLong();
                    timeToLive.setEndDate(endDate);
                }
                timeToLiveDTO = new TimeToLiveDTO(timeToLive);
            }
        } else {
            timeToLiveDTO = new TimeToLiveDTO(TimeToLive.unlimited());
        }
        return timeToLiveDTO;
    }
}

