/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.mockserver.serialization.deserializers.request;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.xdev.mockserver.model.Cookies;
import software.xdev.mockserver.model.Headers;
import software.xdev.mockserver.model.NottableString;
import software.xdev.mockserver.model.Parameters;
import software.xdev.mockserver.model.Protocol;
import software.xdev.mockserver.model.SocketAddress;
import software.xdev.mockserver.serialization.model.BodyDTO;
import software.xdev.mockserver.serialization.model.HttpRequestDTO;
import software.xdev.mockserver.serialization.model.RequestDefinitionDTO;

public class RequestDefinitionDTODeserializer
extends StdDeserializer<RequestDefinitionDTO> {
    private static final Logger LOG = LoggerFactory.getLogger(RequestDefinitionDTODeserializer.class);

    public RequestDefinitionDTODeserializer() {
        super(RequestDefinitionDTO.class);
    }

    public RequestDefinitionDTO deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
        if (jsonParser.getCurrentToken() != JsonToken.START_OBJECT) {
            return null;
        }
        Boolean not = null;
        NottableString method = NottableString.string("");
        NottableString path = NottableString.string("");
        Parameters pathParameters = null;
        Parameters queryStringParameters = null;
        BodyDTO body = null;
        Cookies cookies = null;
        Headers headers = null;
        Boolean keepAlive = null;
        Protocol protocol = null;
        SocketAddress socketAddress = null;
        block28: while (jsonParser.nextToken() != JsonToken.END_OBJECT) {
            String fieldName = jsonParser.currentName();
            if (fieldName == null) continue;
            switch (fieldName) {
                case "not": {
                    jsonParser.nextToken();
                    not = jsonParser.getBooleanValue();
                    continue block28;
                }
                case "method": {
                    jsonParser.nextToken();
                    method = (NottableString)ctxt.readValue(jsonParser, NottableString.class);
                    continue block28;
                }
                case "path": {
                    jsonParser.nextToken();
                    path = (NottableString)ctxt.readValue(jsonParser, NottableString.class);
                    continue block28;
                }
                case "pathParameters": {
                    jsonParser.nextToken();
                    pathParameters = (Parameters)ctxt.readValue(jsonParser, Parameters.class);
                    continue block28;
                }
                case "queryStringParameters": {
                    jsonParser.nextToken();
                    queryStringParameters = (Parameters)ctxt.readValue(jsonParser, Parameters.class);
                    continue block28;
                }
                case "body": {
                    jsonParser.nextToken();
                    body = (BodyDTO)ctxt.readValue(jsonParser, BodyDTO.class);
                    continue block28;
                }
                case "cookies": {
                    jsonParser.nextToken();
                    cookies = (Cookies)ctxt.readValue(jsonParser, Cookies.class);
                    continue block28;
                }
                case "headers": {
                    jsonParser.nextToken();
                    headers = (Headers)ctxt.readValue(jsonParser, Headers.class);
                    continue block28;
                }
                case "keepAlive": {
                    jsonParser.nextToken();
                    keepAlive = (Boolean)ctxt.readValue(jsonParser, Boolean.class);
                    continue block28;
                }
                case "socketAddress": {
                    jsonParser.nextToken();
                    socketAddress = (SocketAddress)ctxt.readValue(jsonParser, SocketAddress.class);
                    continue block28;
                }
                case "protocol": {
                    jsonParser.nextToken();
                    try {
                        protocol = Protocol.valueOf((String)ctxt.readValue(jsonParser, String.class));
                    }
                    catch (Exception ex) {
                        LOG.error("Exception while parsing protocol value for RequestDefinitionDTO", (Throwable)ex);
                    }
                    continue block28;
                }
            }
            LOG.trace("Ignoring field '{}'", (Object)fieldName);
        }
        return (RequestDefinitionDTO)new HttpRequestDTO().setMethod(method).setPath(path).setPathParameters(pathParameters).setQueryStringParameters(queryStringParameters).setBody(body).setCookies(cookies).setHeaders(headers).setKeepAlive(keepAlive).setProtocol(protocol).setSocketAddress(socketAddress).setNot(not);
    }
}

