/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.mockserver.serialization.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Objects;
import software.xdev.mockserver.model.BinaryBody;
import software.xdev.mockserver.model.Body;
import software.xdev.mockserver.model.BodyWithContentType;
import software.xdev.mockserver.model.MediaType;
import software.xdev.mockserver.model.StringBody;
import software.xdev.mockserver.serialization.model.BinaryBodyDTO;
import software.xdev.mockserver.serialization.model.BodyDTO;
import software.xdev.mockserver.serialization.model.StringBodyDTO;

public abstract class BodyWithContentTypeDTO
extends BodyDTO {
    protected final String contentType;

    protected BodyWithContentTypeDTO(Body.Type type, Boolean not, Body<?> body) {
        super(type, not);
        this.contentType = body.getContentType();
        this.withOptional(body.getOptional());
    }

    public static BodyWithContentTypeDTO createWithContentTypeDTO(BodyWithContentType<?> body) {
        BodyDTO result = null;
        if (body instanceof BinaryBody) {
            BinaryBody binaryBody = (BinaryBody)body;
            result = new BinaryBodyDTO(binaryBody, binaryBody.getNot());
        } else if (body instanceof StringBody) {
            StringBody stringBody = (StringBody)body;
            result = new StringBodyDTO(stringBody, stringBody.getNot());
        }
        if (result != null) {
            result.withOptional(body.getOptional());
        }
        return result;
    }

    public String getContentType() {
        return this.contentType;
    }

    @JsonIgnore
    MediaType getMediaType() {
        return this.contentType != null ? MediaType.parse(this.contentType) : null;
    }

    @Override
    public abstract BodyWithContentType<?> buildObject();

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BodyWithContentTypeDTO)) {
            return false;
        }
        BodyWithContentTypeDTO that = (BodyWithContentTypeDTO)o;
        if (!super.equals(o)) {
            return false;
        }
        return Objects.equals(this.getContentType(), that.getContentType());
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getContentType());
    }
}

