/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.mockserver.serialization.model;

import java.util.Objects;
import software.xdev.mockserver.model.ConnectionOptions;
import software.xdev.mockserver.model.ObjectWithJsonToString;
import software.xdev.mockserver.serialization.model.DTO;
import software.xdev.mockserver.serialization.model.DelayDTO;

public class ConnectionOptionsDTO
extends ObjectWithJsonToString
implements DTO<ConnectionOptions> {
    private Boolean suppressContentLengthHeader;
    private Integer contentLengthHeaderOverride;
    private Boolean suppressConnectionHeader;
    private Integer chunkSize;
    private Boolean keepAliveOverride;
    private Boolean closeSocket;
    private DelayDTO closeSocketDelay;

    public ConnectionOptionsDTO(ConnectionOptions connectionOptions) {
        if (connectionOptions != null) {
            this.suppressContentLengthHeader = connectionOptions.getSuppressContentLengthHeader();
            this.contentLengthHeaderOverride = connectionOptions.getContentLengthHeaderOverride();
            this.suppressConnectionHeader = connectionOptions.getSuppressConnectionHeader();
            this.chunkSize = connectionOptions.getChunkSize();
            this.keepAliveOverride = connectionOptions.getKeepAliveOverride();
            this.closeSocket = connectionOptions.getCloseSocket();
            if (connectionOptions.getCloseSocketDelay() != null) {
                this.closeSocketDelay = new DelayDTO(connectionOptions.getCloseSocketDelay());
            }
        }
    }

    public ConnectionOptionsDTO() {
    }

    @Override
    public ConnectionOptions buildObject() {
        return new ConnectionOptions().withSuppressContentLengthHeader(this.suppressContentLengthHeader).withContentLengthHeaderOverride(this.contentLengthHeaderOverride).withSuppressConnectionHeader(this.suppressConnectionHeader).withChunkSize(this.chunkSize).withKeepAliveOverride(this.keepAliveOverride).withCloseSocket(this.closeSocket).withCloseSocketDelay(this.closeSocketDelay != null ? this.closeSocketDelay.buildObject() : null);
    }

    public Boolean getSuppressContentLengthHeader() {
        return this.suppressContentLengthHeader;
    }

    public ConnectionOptionsDTO setSuppressContentLengthHeader(Boolean suppressContentLengthHeader) {
        this.suppressContentLengthHeader = suppressContentLengthHeader;
        return this;
    }

    public Integer getContentLengthHeaderOverride() {
        return this.contentLengthHeaderOverride;
    }

    public ConnectionOptionsDTO setContentLengthHeaderOverride(Integer contentLengthHeaderOverride) {
        this.contentLengthHeaderOverride = contentLengthHeaderOverride;
        return this;
    }

    public Boolean getSuppressConnectionHeader() {
        return this.suppressConnectionHeader;
    }

    public ConnectionOptionsDTO setSuppressConnectionHeader(Boolean suppressConnectionHeader) {
        this.suppressConnectionHeader = suppressConnectionHeader;
        return this;
    }

    public Integer getChunkSize() {
        return this.chunkSize;
    }

    public ConnectionOptionsDTO setChunkSize(Integer chunkSize) {
        this.chunkSize = chunkSize;
        return this;
    }

    public Boolean getKeepAliveOverride() {
        return this.keepAliveOverride;
    }

    public ConnectionOptionsDTO setKeepAliveOverride(Boolean keepAliveOverride) {
        this.keepAliveOverride = keepAliveOverride;
        return this;
    }

    public Boolean getCloseSocket() {
        return this.closeSocket;
    }

    public ConnectionOptionsDTO setCloseSocket(Boolean closeSocket) {
        this.closeSocket = closeSocket;
        return this;
    }

    public DelayDTO getCloseSocketDelay() {
        return this.closeSocketDelay;
    }

    public ConnectionOptionsDTO setCloseSocketDelay(DelayDTO closeSocketDelay) {
        this.closeSocketDelay = closeSocketDelay;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ConnectionOptionsDTO)) {
            return false;
        }
        ConnectionOptionsDTO that = (ConnectionOptionsDTO)o;
        return Objects.equals(this.getSuppressContentLengthHeader(), that.getSuppressContentLengthHeader()) && Objects.equals(this.getContentLengthHeaderOverride(), that.getContentLengthHeaderOverride()) && Objects.equals(this.getSuppressConnectionHeader(), that.getSuppressConnectionHeader()) && Objects.equals(this.getChunkSize(), that.getChunkSize()) && Objects.equals(this.getKeepAliveOverride(), that.getKeepAliveOverride()) && Objects.equals(this.getCloseSocket(), that.getCloseSocket()) && Objects.equals(this.getCloseSocketDelay(), that.getCloseSocketDelay());
    }

    public int hashCode() {
        return Objects.hash(this.getSuppressContentLengthHeader(), this.getContentLengthHeaderOverride(), this.getSuppressConnectionHeader(), this.getChunkSize(), this.getKeepAliveOverride(), this.getCloseSocket(), this.getCloseSocketDelay());
    }
}

