/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.mockserver.serialization.model;

import java.util.Objects;
import software.xdev.mockserver.model.Delay;
import software.xdev.mockserver.model.HttpClassCallback;
import software.xdev.mockserver.serialization.model.DTO;
import software.xdev.mockserver.serialization.model.DelayDTO;

public class HttpClassCallbackDTO
implements DTO<HttpClassCallback> {
    private String callbackClass;
    private DelayDTO delay;

    public HttpClassCallbackDTO(HttpClassCallback httpClassCallback) {
        if (httpClassCallback != null) {
            this.callbackClass = httpClassCallback.getCallbackClass();
            if (httpClassCallback.getDelay() != null) {
                this.delay = new DelayDTO(httpClassCallback.getDelay());
            }
        }
    }

    public HttpClassCallbackDTO() {
    }

    @Override
    public HttpClassCallback buildObject() {
        Delay delay = null;
        if (this.delay != null) {
            delay = this.delay.buildObject();
        }
        return (HttpClassCallback)new HttpClassCallback().withCallbackClass(this.callbackClass).withDelay(delay);
    }

    public String getCallbackClass() {
        return this.callbackClass;
    }

    public HttpClassCallbackDTO setCallbackClass(String callbackClass) {
        this.callbackClass = callbackClass;
        return this;
    }

    public DelayDTO getDelay() {
        return this.delay;
    }

    public void setDelay(DelayDTO delay) {
        this.delay = delay;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HttpClassCallbackDTO)) {
            return false;
        }
        HttpClassCallbackDTO that = (HttpClassCallbackDTO)o;
        return Objects.equals(this.getCallbackClass(), that.getCallbackClass()) && Objects.equals(this.getDelay(), that.getDelay());
    }

    public int hashCode() {
        return Objects.hash(this.getCallbackClass(), this.getDelay());
    }
}

