/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.mockserver.serialization.model;

import java.util.Objects;
import software.xdev.mockserver.model.Delay;
import software.xdev.mockserver.model.HttpForward;
import software.xdev.mockserver.serialization.model.DTO;
import software.xdev.mockserver.serialization.model.DelayDTO;

public class HttpForwardDTO
implements DTO<HttpForward> {
    private String host;
    private Integer port;
    private HttpForward.Scheme scheme;
    private DelayDTO delay;

    public HttpForwardDTO(HttpForward httpForward) {
        if (httpForward != null) {
            this.host = httpForward.getHost();
            this.port = httpForward.getPort();
            this.scheme = httpForward.getScheme();
            if (httpForward.getDelay() != null) {
                this.delay = new DelayDTO(httpForward.getDelay());
            }
        }
    }

    public HttpForwardDTO() {
    }

    @Override
    public HttpForward buildObject() {
        Delay delay = null;
        if (this.delay != null) {
            delay = this.delay.buildObject();
        }
        return (HttpForward)new HttpForward().withHost(this.host).withPort(this.port != null ? this.port : 80).withScheme(this.scheme != null ? this.scheme : HttpForward.Scheme.HTTP).withDelay(delay);
    }

    public String getHost() {
        return this.host;
    }

    public HttpForwardDTO setHost(String host) {
        this.host = host;
        return this;
    }

    public Integer getPort() {
        return this.port;
    }

    public HttpForwardDTO setPort(Integer port) {
        this.port = port;
        return this;
    }

    public HttpForward.Scheme getScheme() {
        return this.scheme;
    }

    public HttpForwardDTO setScheme(HttpForward.Scheme scheme) {
        this.scheme = scheme;
        return this;
    }

    public DelayDTO getDelay() {
        return this.delay;
    }

    public void setDelay(DelayDTO delay) {
        this.delay = delay;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HttpForwardDTO)) {
            return false;
        }
        HttpForwardDTO that = (HttpForwardDTO)o;
        return Objects.equals(this.getHost(), that.getHost()) && Objects.equals(this.getPort(), that.getPort()) && this.getScheme() == that.getScheme() && Objects.equals(this.getDelay(), that.getDelay());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.getHost(), this.getPort(), this.getScheme(), this.getDelay()});
    }
}

