/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.mockserver.mock;

import java.io.Serializable;
import java.util.Comparator;
import java.util.Objects;
import software.xdev.mockserver.collections.Keyed;

public class SortableExpectationId
implements Keyed<String> {
    public static final SortableExpectationId NULL = new SortableExpectationId("", 0, 0L);
    public static final Comparator<SortableExpectationId> EXPECTATION_SORTABLE_PRIORITY_COMPARATOR = (Comparator & Serializable)(expectationOne, expectationTwo) -> {
        if (expectationOne == null) {
            return expectationTwo == null ? 0 : 1;
        }
        if (expectationTwo == null) {
            return -1;
        }
        int priorityComparison = Integer.compare(expectationTwo.priority, expectationOne.priority);
        if (priorityComparison != 0) {
            return priorityComparison;
        }
        int createdComparison = Long.compare(expectationOne.created, expectationTwo.created);
        if (createdComparison != 0) {
            return createdComparison;
        }
        return expectationOne.id.compareTo(expectationTwo.id);
    };
    private final int hashCode;
    private final String id;
    private final int priority;
    private final long created;

    public SortableExpectationId(String id, int priority, long created) {
        this.id = id;
        this.priority = priority;
        this.created = created;
        this.hashCode = Objects.hash(id, priority, created);
    }

    public int getHashCode() {
        return this.hashCode;
    }

    public String getId() {
        return this.id;
    }

    public int getPriority() {
        return this.priority;
    }

    public long getCreated() {
        return this.created;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SortableExpectationId that = (SortableExpectationId)o;
        return this.hashCode == that.hashCode && this.priority == that.priority && this.created == that.created && Objects.equals(this.id, that.id);
    }

    public int hashCode() {
        return this.hashCode;
    }

    @Override
    public String getKey() {
        return this.id;
    }
}

