/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.mockserver.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.nio.charset.Charset;
import java.util.Objects;
import software.xdev.mockserver.model.Body;
import software.xdev.mockserver.model.MediaType;

public abstract class BodyWithContentType<T>
extends Body<T> {
    private int hashCode;
    protected final MediaType contentType;

    protected BodyWithContentType(Body.Type type, MediaType contentType) {
        super(type);
        this.contentType = contentType;
    }

    @JsonIgnore
    Charset determineCharacterSet(MediaType mediaType, Charset defaultCharset) {
        Charset charset;
        if (mediaType != null && (charset = mediaType.getCharset()) != null) {
            return charset;
        }
        return defaultCharset;
    }

    @Override
    @JsonIgnore
    public Charset getCharset(Charset defaultIfNotSet) {
        return this.determineCharacterSet(this.contentType, defaultIfNotSet);
    }

    @Override
    public String getContentType() {
        return this.contentType != null ? this.contentType.toString() : null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (this.hashCode() != o.hashCode()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BodyWithContentType that = (BodyWithContentType)o;
        return Objects.equals(this.contentType, that.contentType);
    }

    @Override
    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = Objects.hash(super.hashCode(), this.contentType);
        }
        return this.hashCode;
    }
}

