/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.mockserver.serialization.deserializers.string;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import software.xdev.mockserver.model.NottableOptionalString;
import software.xdev.mockserver.model.NottableString;
import software.xdev.mockserver.model.ParameterStyle;
import software.xdev.mockserver.util.StringUtils;

public class NottableStringDeserializer
extends StdDeserializer<NottableString> {
    public NottableStringDeserializer() {
        super(NottableString.class);
    }

    public NottableString deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
        if (jsonParser.getCurrentToken() == JsonToken.START_OBJECT) {
            Boolean not = null;
            Boolean optional = null;
            String value = null;
            ParameterStyle parameterStyle = null;
            while (jsonParser.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = jsonParser.currentName();
                if ("not".equals(fieldName)) {
                    jsonParser.nextToken();
                    not = jsonParser.getBooleanValue();
                    continue;
                }
                if ("optional".equals(fieldName)) {
                    jsonParser.nextToken();
                    optional = jsonParser.getBooleanValue();
                    continue;
                }
                if ("value".equals(fieldName)) {
                    jsonParser.nextToken();
                    value = (String)ctxt.readValue(jsonParser, String.class);
                    continue;
                }
                if (!"parameterStyle".equals(fieldName)) continue;
                jsonParser.nextToken();
                parameterStyle = (ParameterStyle)((Object)ctxt.readValue(jsonParser, ParameterStyle.class));
            }
            NottableString result = null;
            if (Boolean.TRUE.equals(optional)) {
                result = NottableOptionalString.optional(value, not);
            } else if (StringUtils.isNotBlank(value)) {
                result = NottableString.string(value, not);
            }
            if (result != null && parameterStyle != null) {
                result.withStyle(parameterStyle);
            }
            return result;
        }
        if (jsonParser.getCurrentToken() == JsonToken.VALUE_STRING || jsonParser.getCurrentToken() == JsonToken.FIELD_NAME) {
            return NottableString.string((String)ctxt.readValue(jsonParser, String.class));
        }
        return null;
    }
}

